/*
// PROGRAM NAME:  HANDLES.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program is a simple example of how the executive handle
//	management functions can be called from large-model C applications.
//	The program allocates a handle to an object, references the object,
//	dereferences the handle, and dealloctes the handle, showing how
//	the reference and dereference routines are called.
//
// MODIFICATION HISTORY.
//	S. E. Jones	93/09/18.	#1.106, original.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE ARGUMENTS.
//	none.
//
// NOTICE:  Copyright (C) 1993-1995 General Software, Inc.
*/

#define VOID void
#define UCHAR unsigned char
#define USHORT unsigned short
#define ULONG unsigned long
#define FALSE 0
#define TRUE (!FALSE)

#include <stdio.h>
#include <malloc.h>

#include "..\inc\handle.h"	 // handle API definitions.

VOID ObjectReferenceRoutine (PVOID Token)
{
    printf ("The object %08lx has been referenced.\n", Token);
} // ObjectReferenceRoutine

VOID ObjectDereferenceRoutine (PVOID Token)
{
    printf ("The object %08lx has been dereferenced.\n", Token);
} // ObjectDereferenceRoutine

VOID main (int argc, char *argv[])
{
    HANDLE Handle;
    PVOID Table;
    PVOID Object;
    PVOID ObjPtr;

    printf ("This is a simple C program that uses executive handles.\n");

    Table = malloc (100);
    if (Table == NULL) {
	printf ("Unable to malloc 100-byte handle table.\n");
	exit (-1);
    }
    if (!ExCreateHandleTable (Table, 100)) {
	free (Table);
	printf ("Unable to create handle table.\n");
	exit (-1);
    }

    Object = malloc (10);
    if (!ExAllocateHandle (Table,
			   Object,
			   (PHANDLE_REFERENCE_ROUTINE)ObjectReferenceRoutine,
			   (PHANDLE_DEREFERENCE_ROUTINE)ObjectDereferenceRoutine,
			   &Handle)) {
	ExCloseHandleTable (Table);
	free (Table);
	printf ("Unable to allocate the first handle.\n");
	exit (-1);
    }

    if (!ExAccessHandle (Table,
			 Handle,
			 &ObjPtr)) {
	ExCloseHandleTable (Table);
	free (Table);
	free (Object);
	printf ("Unable to access the object through the handle.\n");
	exit (-1);
    }

    if (Object != ObjPtr) {
	ExCloseHandleTable (Table);
	free (Table);
	free (Object);
	printf ("The wrong object pointer was returned.\n");
	exit (-1);
    }

    ExDeaccessHandle (Table, Handle);	// close ExAccessHandle reference.
    ExDeaccessHandle (Table, Handle);	// close ExAllocateHandle ref.

    //
    // Clean up and return to DOS.
    //

    free (Object);
    ExCloseHandleTable (Table);
    free (Table);
    exit (0);			// successfully return to Embedded DOS.
} // handles.c
