	TITLE	POPBASE - Popup TSR (Base Portion).

;***	POPBASE -- Popup TSR (Base Portion).
;
;1.	Functional Description.
;	This module implements the first portion of a hybrid C/assembly
;	program that forms a popup TSR that does background processing
;	while the foreground program runs.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	Original template (CON driver).
;	S. E. Jones	91/12/13.	#1.00 adapted from CON driver.
;	S. E. Jones	91/12/29.	#1.094, adapted from SMB server code.
;	S. E. Jones	92/09/06.	#1.100, supported new include files.
;	S. E. Jones	94/12/28.	#2.2, removed bug flags.
;
;3.	NOTICE: Copyright (C) 1991-1994 General Software, Inc.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

DefApi	MACRO	lab
	DefProc lab, PUBLIC, FAR
	ENDM

EndApi	MACRO	lab
	EndProc lab
	ENDM

P0	EQU	bp+6
P1	EQU	bp+8
P2	EQU	bp+10
P3	EQU	bp+12
P4	EQU	bp+14
P5	EQU	bp+16
P6	EQU	bp+18
P7	EQU	bp+20
P8	EQU	bp+22
P9	EQU	bp+24

	include ..\inc\defines.inc
	include ..\inc\kernel.inc
	include ..\inc\dosapi.inc
	include ..\inc\doserr.inc
	include ..\inc\umacros.inc
	include ..\inc\ustruc.inc

	EXTRN	_PopupInit:FAR		; in POPUP.C.
	EXTRN	_Popup:FAR		; in POPUP.C.

UCODE	SEGMENT WORD PUBLIC 'CODE'
UCODE	ENDS

	include ..\inc\usegs.inc

_DATA	SEGMENT
_DATA	ENDS

UCODE	SEGMENT

OldInt9         dd	?		; FWA, BIOS INT 9 ISR.
SavedPsp	dw	?		; saved seg FWA, PSP.
LastSeg         dw	?		; save seg FWA, ZSEG.
DosData         dw	?		; DOSDATA segment (STARLITE ONLY).
SavedCursor	dw	?		; saved cursor position.

	PUBLIC	__acrtused		; don't include C-runtime startup code.
__acrtused	=	$

UCODE	ENDS

UCODE	SEGMENT

;***	Initialize - Popup Initialization Code.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by the main routine below to initialize the
;	popup TSR, hooking INT 09h, calling _PopupInit in C.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/29.	#1.094, original for popup program.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	AX	- number of paragraphs reserved for heap.
;
;   USES.
;	all but CS.

	ASSUME	CS:CGROUP, DS:DGROUP, ES:NOTHING, SS:NOTHING
DefProc Initialize
	push	ds
	push	es

	cld				; forward string operations.
	mov	ax, DGROUP
	mov	ds, ax
	mov	ax, ZSEG
	mov	LastSeg, ax		; save this for later.
	push	ax
	mov	ax, OFFSET ZSEG:zzzsym
	push	ax			; pass FWA, 1st free byte of memory.
	call	_PopupInit		; initialize the C code.
	add	sp, 4			; remove param from stack.

	pop	es
	pop	ds
EndProc Initialize

;***	_TaskBar - Display Top Bar on Screen.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by POPUP.C to display a menu on the top
;	line of the screen with a specified attribute.	We use the BIOS
;	to actually write the char/attr pairs to the screen.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/08/02.	Original for COMMAND.COM.
;	S. E. Jones	91/12/13.	Modified for SMB server.
;	S. E. Jones	93/09/19.	Moved to Popup utility.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	[P0,P1] - FWA, ASCIIZ title to be displayed.
;	[P2]	- attribute byte.
;
;   EXIT.
;	none.
;
;   USES.
;	all but SI, DI, DS, ES.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_TaskBar
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

	mov	ah, 3			; (AH) = get cursor position.
	sub	bx, bx			; (BH) = page number 0.
	int	10h			; call video BIOS to get cursor position.
	push	dx			; save (DH)=row, (DL)=col.

	sub	dx, dx			; (DH/DL) = row/col.
	mov	ah, 2			; (AH) = set cursor position.
	mov	cx, 80			; (CX) = max # of chars to display.
	lds	si, [P0]		; (DS:SI) = FWA, string to display.
TaskBar_Loop:
	lodsb				; (AL) = next character to display.
	or	al, al			; is it the end of the string?
	jnz	@f			; if not.
	dec	si			; (DS:SI) = FWA, 0-byte again.
	mov	al, 20h                 ; (AL) = blank.

@@:	push	dx
	push	cx
	push	ax			; save our character.
	mov	ah, 2			; (AH) = set cursor position function.
	sub	bx, bx			; (BH) = page 0.
	int	10h			; set our cursor position.
	pop	ax			; (AL) = our character to display.
	mov	ah, 9			; (AH) = write char/attr to screen.
	mov	bx, [P2]		; (BL) = attribute (usually WHITE on BLUE).
	sub	bh, bh			; (BH) = page 0.
	mov	cx, 1			; (CX) = # chars to write.
	int	10h			; write the character.
	pop	cx
	pop	dx
	inc	dl			; (DL) = next column number.
	loop	TaskBar_Loop

	pop	dx
	mov	ah, 2			; (AH) = set cursor position.
	sub	bx, bx			; (BH) = page number 0.
	int	10h			; restore cursor position.

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_TaskBar

;***	_GetChar - Return Next BIOS Keyboard Character.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by the C-language code to read a character
;	from the keyboard with wait.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/31.	#1.00, original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	AX	- character returned.
;
;   USES.
;	all but SI, DI, DS, ES.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_GetChar
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

	sub	ah, ah			; (AH) = read keyboard input func.
	int	16h			; read char into AL.
	sub	ah, ah			; zap scan code & return 16-bit char.

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_GetChar

;***	ClrScr - Clear Screen.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by its C main program to clear the screen.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/03/09.	Original.
;
;   WARNINGS.
;	We may want to check for very large screens.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	All but SI, DI, DS, ES.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_ClrScr
	push	bp
	mov	bp, sp
	push	si
	push	di

;	Erase the screen.

	mov	ax, 0600h		;bios scroll window function.
	sub	cx, cx			;row=0, col=0.
	mov	dx, 184fh		;row=24, col=79.
	mov	bh, 07h                 ;light grey on black.
	int	10h

;	Position the cursor to the upper left-hand corner of the screen.

	sub	dl, dl			; (DL) = column.
	sub	dh, dh			; (DH) = row.
	sub	bx, bx			; (BX) = page 0.
	mov	ah, 2			; set cursor position function.
	int	10h

	pop	di
	pop	si
	pop	bp
EndApi	_ClrScr

;***	_BlankScreen - Clear Screen Without Moving Cursor.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by its C main program to blank the screen,
;	leaving the cursor where it was.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/03/09.	Original for ClrScr.
;	S. E. Jones	91/12/31.	#1.094, removed cursor positioning.
;
;   WARNINGS.
;	We may want to check for very large screens.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	All but SI, DI, DS, ES.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_BlankScreen
	push	bp
	mov	bp, sp
	push	si
	push	di

;	Erase the screen.

	mov	ax, 0600h		;bios scroll window function.
	sub	cx, cx			;row=0, col=0.
	mov	dx, 184fh		;row=24, col=79.
	mov	bh, 07h                 ;light grey on black.
	int	10h

	pop	di
	pop	si
	pop	bp
EndApi	_BlankScreen

;***	_CursorColumn - Read Hardware Cursor X-Coordinate.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by its C main program to return the
;	current cursor column on the hardware screen.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/03/09.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	AX	- current cursor column.
;
;   USES.
;	All but SI, DI, DS, ES.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_CursorColumn
	push	bp
	mov	bp, sp
	push	si
	push	di

	mov	ah, 03h                 ; (AH) = read cursor position.
	sub	bx, bx			; (BX) = display page number.
	int	10h			; (DH) = row, (DL) = column.
	sub	ax, ax
	mov	al, dl			; (AX) = current cursor column.

	pop	di
	pop	si
	pop	bp
EndApi	_CursorColumn

;***	_CursorRow - Read Hardware Cursor Y-Coordinate.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by its C main program to return the
;	current cursor row on the hardware screen.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/03/09.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	AX	- current cursor row.
;
;   USES.
;	All but SI, DI, DS, ES.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_CursorRow
	push	bp
	mov	bp, sp
	push	si
	push	di

	mov	ah, 03h                 ; (AH) = read cursor position.
	sub	bx, bx			; (BX) = display page number.
	int	10h			; (DH) = row, (DL) = column.
	sub	ax, ax
	mov	al, dh			; (AX) = current cursor row.

	pop	di
	pop	si
	pop	bp
EndApi	_CursorRow

;***	_SaveScreenMemory - Copy Screen Memory To Software Buffer.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by its C main program to save the contents
;	of the currently-displayed screen in a software buffer that we can
;	restore the screen with later.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/03/09.	Original.
;
;   WARNINGS.
;	The algorithm could be improved upon with REP MOVSD on 386's.
;
;   ENTRY.
;	[P0,P1] - FWA, buffer to save screen in.
;
;   EXIT.
;	none.
;
;   USES.
;	All but SI, DI, DS, ES.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_SaveScreenMemory
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

;	Figure out where the screen memory is.	We call the video BIOS
;	to get our "video status", which returns the current mode.  If
;	this mode is 7, then we're on a monochrome adapter that has its
;	regen buffer at b000:0000.  Otherwise, the buffer is at b800:0000.

	mov	ah, 0fh                 ; (AH) = return video status function code.
	int	10h			; (AL) = current mode.

	mov	dx, 0b000h		; (DX) = mono, by default.
	cmp	al, 7			; are we on mono?
	je	@f			; if so.
	mov	dx, 0b800h		; nope, we're on color.
@@:	mov	ds, dx			; (DS) = seg FWA, screen.
	sub	si, si			; (DS:SI) = FWA, source buffer.

;	Now load-up our software buffer pointer, and copy the data.

	les	di, [P0]		; (ES:DI) = FWA, destination buffer.
	mov	cx, 25*80		; (CX) = # char/attr pairs to move as words.
	rep	movsw			; copy the screen.

;	Save the cursor position.

	mov	ah, 03h                 ; (AH) = read cursor position.
	sub	bx, bx			; (BX) = display page number.
	int	10h			; (DH) = row, (DL) = column.
	mov	SavedCursor, dx         ; (DL) = column, (DH) = row.

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_SaveScreenMemory

;***	_RestoreScreenMemory - Copy Software Buffer To Screen Memory.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by its C main program to restore the contents
;	of a background screen from a software buffer to the hardware screen.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/03/09.	Original.
;
;   WARNINGS.
;	The algorithm could be improved upon with REP MOVSD on 386's.
;
;   ENTRY.
;	[P0,P1] - FWA, buffer to restore screen from.
;
;   EXIT.
;	none.
;
;   USES.
;	All but SI, DI, DS, ES.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_RestoreScreenMemory
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

;	Figure out where the screen memory is.	We call the video BIOS
;	to get our "video status", which returns the current mode.  If
;	this mode is 7, then we're on a monochrome adapter that has its
;	regen buffer at b000:0000.  Otherwise, the buffer is at b800:0000.

	mov	ah, 0fh                 ; (AH) = return video status function code.
	int	10h			; (AL) = current mode.

	mov	dx, 0b000h		; (DX) = mono, by default.
	cmp	al, 7			; are we on mono?
	je	@f			; if so.
	mov	dx, 0b800h		; nope, we're on color.
@@:	mov	es, dx			; (ES) = seg FWA, screen.
	sub	di, di			; (ES:DI) = FWA, destination buffer.

;	Now load-up our software buffer pointer, and copy the data.

	lds	si, [P0]		; (DS:SI) = FWA, source buffer.
	mov	cx, 25*80		; (CX) = # char/attr pairs to move as words.
	rep	movsw			; copy to the screen.

;	Reposition the cursor.

	mov	dx, SavedCursor         ; (DL) = column, (DH) = row.
	sub	bx, bx			; (BX) = page 0.
	mov	ah, 2			; set cursor position function.
	int	10h

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_RestoreScreenMemory

;***	Int09Handler - Keyboard Interrupt Service Routine.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is invoked from a hardware interrupt generated by the
;	keyboard controller whenever a key on the keyboard is pressed or
;	released.  This allows us to get control to determine if the user
;	is pressing the SHF-SHF key combo.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/31.	#1.094, original for popup TSR demo.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	None.
;
;   EXIT.
;	None.
;
;   USES.
;	None.

	ASSUME	SS:NOTHING, CS:CGROUP, DS:NOTHING, ES:NOTHING
DefProc Int09Handler, FAR
	pushf
	call	dword ptr [OldInt9]

	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	push	es
	push	bp

;	Check the keyboard shift flags.

	push	es
	mov	ax, 40h                 ; (40:17) = FWA, keyboard shift flags.
	mov	es, ax
	mov	al, es:[17h]		; (AL) = keyboard shift flags.
	pop	es

RIGHT_SHIFT	= 00000001b
LEFT_SHIFT	= 00000010b
CTRL_KEY	= 00000100b
ALT_KEY         = 00001000b

	and	al, LEFT_SHIFT OR RIGHT_SHIFT
	cmp	al, LEFT_SHIFT OR RIGHT_SHIFT ; are those exact keys depressed?
	jne	Int09Handler_Exit	; nope, don't pop-up.

	cld				; forward direction string ops.
	mov	ax, DGROUP
	mov	ds, ax			; (DS) = DGROUP for C.
	call	_Popup			; does the pop-up immediately.

Int09Handler_Exit:
	pop	bp
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	iret
EndProc Int09Handler

;***	StartLabel - Program Start Execution Address.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by Embedded DOS when the program is loaded.
;	It initializes the TSR and then terminates, leaving its code hooked
;	to INT 09h so that it can pop-up whenever a SHF-SHF key combo is pressed.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/29.	#1.094, original for popup TSR demo.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	None.
;
;   EXIT.
;	None.
;
;   USES.
;	None.

	ASSUME	SS:NOTHING, CS:CGROUP, DS:NOTHING, ES:NOTHING
DefProc StartLabel, FAR
	mov	SavedPsp, ds		; save the PSP segment address.

;	Chain the keyboard interrupt with our own ISR.

	sub	ax, ax
	mov	es, ax
	cli				; BEGIN CRITICAL SECTION.
	push	word ptr es:[09h*4+0]	; ofs half, ISR 9 ptr.
	pop	OldInt9.lo
	push	word ptr es:[09h*4+2]	; seg half, ISR 9 ptr.
	pop	OldInt9.hi
	mov	word ptr es:[09h*4+0], OFFSET CGROUP:Int09Handler
	mov	word ptr es:[09h*4+2], cs
	sti				; END CRITICAL SECTION.

;	Initialize us now.  When we get back from the Initialize routine,
;	(AX)=# paragraphs of stack to keep starting at ZSEG, the last
;	segment in this load.  Use this value to terminate and stay resident.

	Pcall	Initialize		; does initialization, (AX)=#extra para.
	mov	dx, LastSeg		; (DX) = seg FWA, 1st dynamic seg.
	add	dx, ax			; (DX) = seg FWA, 1st unused seg.
	sub	dx, SavedPsp		; (DX) = size to keep (paragraphs).
	inc	dx			; round up.
	mov	ah, DOSTSR		; (AH) = Terminate & Stay Resident.
	sub	al, al			; (AL) = return code (success).
	int	21h			; return control to system.

;	In case DOSTSR can't terminate, drop into debugger.

	int	3			; just in case.
EndProc StartLabel

UCODE	ENDS

ZSEG	SEGMENT PARA PUBLIC 'ZZZZ'
zzzsym	dw	?			; last word in the load.
ZSEG	ENDS

	END	StartLabel
