;***	EVENT.INC -- Embedded DOS Event Object.
;
;1.	Functional Description.
;	The following structure defines an event object.  This object is
;	manipulated by the routines in EVENT.ASM.  All event objects are
;	allocated from system pool, so they are all addressable in DOSDATA.
;	The EVENT object is not visible to kernel components that use the
;	EVENT object, but it is included here for the debugger.
;
;	Operations on events are:
;	    AllocateEvent - Create event and initialize it to the CLEARED state.
;	    FreeEvent - Destroy event and all threads blocked on it.
;	    SetEvent - Set event's state to SET.
;	    ClearEvent - Set event's state to CLEARED.
;	    PulseEvent - Pulse event's state momentarily and unblock one thread.
;	    QueryEvent - Determine event's state.
;	    WaitEvent - Block until event is set or pulsed.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

EVENT		struc
event_flags	dw	?		; current state of event.
EVENT		ends

EVENT_FLAGS_SET =  0001h		; if 1 event is set, else it is clear.
