;***	GLOBALS.INC -- Embedded DOS Common Kernel Data Structures.
;
;1.	Functional Description.
;	This include file contains the global data used in Embedded DOS.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/02/03.	Added UNCFSD pointer.
;	S. E. Jones	91/02/18.	Added OemAcctNo.
;	S. E. Jones	91/03/04.	Reduced threads from 16 to 5.
;	S. E. Jones	91/03/09.	Fixed anchor block's fields.
;	S. E. Jones	91/05/20.	Removed PoolArea for reorg.
;	S. E. Jones	91/06/29.	Added more swappable data area stuff.
;	S. E. Jones	91/07/10.	#1.086, added BIOS wrappers for 10h, 16h.
;	S. E. Jones	91/07/26.	#1.087, removed static alert buffers.
;	S. E. Jones	91/07/28.	#1.088, removed cooked buffer stuff.
;	S. E. Jones	91/08/09.	#1.090, removed ErrorGuru.
;	S. E. Jones	91/09/08.	#1.091, added fake NUL device header.
;	S. E. Jones	92/01/02.	#1.094, removed init of variable in DOSDATA.
;	S. E. Jones	92/01/03.	#1.094, added windows data area.
;	S. E. Jones	93/09/26.	#2.000, release.
;	C. S. Rhodes	94/10/25.	#2.2, changed processor type definition.
;	S. E. Jones	95/01/24.	#2.2, release.
;	C. S. Rhodes	95/02/03.	#2.2, moved InDebugger to DOSDATA.
;	S. E. Jones	95/02/14.	#2.2.18, made currdrive a byte, added SDA type.
;	S. E. Jones	95/02/18.	#2.2.19, extended SDA for Win enh mode.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

	IFNDEF	ERROR_MODULE
	EXTRN	DisplayFar:FAR		     ; in ERROR.ASM.
	EXTRN	PushRegistersByMaskFar:FAR   ; in ERROR.ASM.
	EXTRN	PopRegistersByMaskFar:FAR    ; in ERROR.ASM.
	ENDIF	; (ERROR_MODULE)

;	This segment (_DATA) is used to hold miscellaneous common data.
;	Note that it does not compile for modules which define SYSINITDATA.
;	Currently, only SYSINIT.ASM defines this.

_DATA	SEGMENT

Global	DynDS, WORD, 0			; seg adr, DOSDATA.

;	The following two globals MUST remain together as they are used
;	in CONFIG.ASM as an EXEC function parameter block to load device
;	drivers as overlays.  The first word is the segment address of
;	free memory where a driver is loaded at, and the second word is
;	the relocation fixup that the loader should apply.  In the case
;	of loading device drivers, SysReloc is assigned a copy of SysHeap.
;	However, NO OTHER ROUTINES should use SysReloc nor should they
;	assume that there is something magical stored there.

Global	SysHeap, WORD, 0		; seg ptr, unallocated memory.
Global	SysReloc, WORD, 0		; relocation fixup for device driver loads.

;	Here's some more global parameters in DGROUP.

Global	HeapSize, WORD, 0		; size of heap in paragraphs.
Global	TimeStamp, DWORD, 0		; real-time ticks since midnight.
Global	CritLevel, WORD, 1		; nesting count of critical sections.
Global	StackChain, WORD, 0		; chain of INT 21h stack segments.

;	The following variables start with "c_" because they are constants.
;	They are initialized in SYSINIT.ASM (ConfigureSystem gets them from
;	CONFIG.SYS).

;	<<< ADD MORE DATA ITEMS ABOVE THIS LINE >>>

_DATA	ENDS

;	The following segment definition describes the layout of a DYNAMICALLY
;	ALLOCATED segment (SYSINIT does this).	We use the "AT 0" syntax to
;	fool the assembler into not generating any actual data records for
;	the linker which would be included as static data in the .ABS file.

DOSDATA SEGMENT
InitDS		dw	?	; copy of DGROUP for easy reference.
InDebugger	dw	?	; indicates if debugger is active.
SdaType         db	?	; 0=3.x-formatted SDA, 1=4.x-formatted SDA.
		db	?	; filler for alignment.
FileList	dw	?	; offset in DOSDATA of FFO list.
TimerArray	dw	?	; offset in DOSDATA of timer list.

;	System flags for identifying DOSDATA capabilities.

SysFlags	dw	?	; system capabilities flags.
SYSFLAGS_386	=	0001h	; set if running in a 386 environment or better.
SYSFLAGS_INITDD	=	0002h	; set if currently in system initialization.


Processor	dw	?	; processor type: 0=8088, 200h=V-Series,
				;		  1=80186, 2=80286, 3=80386.
OemAcctNo	dw	?	; General Software-assigned OEM account #.
SysVersion	dw	?	; version number in packed format.

;	The following is returned by INT 2fh function 1607h DOSMGR startup fn.

DosMgrData	label	word	; fields initialized by INT 2fh fn 1607h.
DosMgrVersion	dw	?	; 3 for Embedded DOS, 5 for DOS5.
DosMgrSaveDs	dw	?	; offset of SaveDs variable.
DosMgrSaveBx	dw	?	; offset of SaveBx variable.
DosMgrInDos	dw	?	; offset of InDosFlag (see below).
DosMgrMachineId dw	?	; offset of machine ID variable.
DosMgrPatchArry dw	?	; offset of DOS patch array (0 terminated).

;	Dummy variables needed by the DOSMGR data but not Embedded DOS.
;	These variables are pointed to by the above structure elements.

DosMgrDsVar	dw	?	; the Saved DS variable.
DosMgrBxVar	dw	?	; the Saved BX variable.
DosMgrMid	dw	?	; the machine ID.
DosMgrPatch	dw	?	; must be 0 (0-terminated patch array).

;	System pool data (see POOL.ASM).

SystemPool	dw	?	; offset FWA, first free pool block.

;	Memory system data.  The ArenaBase field MUST immediately be
;	followed by the system anchor block because Microsoft C programs
;	find the arena base that way (ugh!).

MemoryStrategy	dw	?	; current memory strategy.
ArenaBase	dw	?	; seg FWA, base memory arena.

;	System anchor block returned by DosGetAnchor, INT 21h API function 52h.
;	You cannot modify the organization of this structure because programs
;	depend on this stuff being in the same order.  Some of these things
;	are faked up; i.e., Embedded DOS doesn't use them, but they are built so
;	that nasty programs like Microsoft Windows that inspect this garbage
;	can still load.  Where they are, the word "FAKE" is indicated on a
;	field's comments.  See the ACB.INC header file for details about this
;	structure.

SystemAnchorBlock label byte	; structure returned by DosGetAnchor.
DpbChain	dd	?	; FWA, list of DPB's (terminated by ffff:ffff).
SftChain	dd	?	; FAKE: FWA, DOS SFT (terminated by ffff:ffff).
ClockDevHeader	dd	?	; FWA, CLOCK$ device header.
ConDevHeader	dd	?	; FWA, CON device header.
SysBlockSize	dw	?	; the sector size for the system.
DosBufList	dd	?	; FAKE: FWA, DOS buffer chain.
CdsTable	dd	?	; FAKE: FWA, DOS CDS table.
FcbTable	dd	?	; FAKE: FWA, DOS FCB table.
ProtFcbs	dw	?	; FAKE: # protected FCB's in table.
NextDrive	db	?	; number of drives allocated.
CdsTableSize	db	?	; FAKE: number of CDS's in CdsTable.
DeviceList	dd	?	; device driver chain.
NulAttr         dw	?	; FAKE: NUL device driver attributes.
NulStrat	dw	?	; FAKE: code offset, strategy ept.
NulIntr         dw	?	; FAKE: code offset, interrupt entrypoint.
NulName         db	8 dup (?) ; FAKE: the NUL driver's name.
JoinedDrives	db	?	; FAKE: number of joined drives.

;	Miscellaneous DOS function data not associated with the anchor block,
;	but obviously addressable from the end of it.

VerifyFlag	db	?	; current verify flag (0=off, 1=on).
BreakFlag	db	?	; current break flag (0=off, 1=on).
CtrlCFlag	db	?	; CTRL-C indicator (0=no pending ctrlc, 1=pending).
		db	?	; padding.
SwitchChar	db	?	; current switch character (default='/').
DAB		db	?	; current Device Availability Byte (default=0).

;	Function 34h returns the address of the InDosFlag (the second field
;	below), but the CritErrFlag value can be reached from it with a -1
;	relative offset.  The whole group of data items (starting with the
;	CritErrFlag) are all referred to in "Undocumented DOS" as the Swappable
;	Data Area, or SDA.  Those fields marked with a (!!!) are actually used
;	by Embedded DOS.  Note that CurrDrive is spec'd as a byte in Undocumented
;	DOS, but is a word when used in Embedded DOS.  The high byte of that word
;	is treated by DOS apps as an extended break flag, which probably doesn't
;	matter.

BEGIN_SDA	=	$	; start of the SDA here (see DosServer API).
CritErrFlag	db	?	; (!!!) always zero, since we don't dispatch to apps.
InDosFlag	db	?	; (!!!) function 34h returns ptr to this.
ErrorDrive	db	?	; drive on which crit error occurred (ffh if none).
ErrorLocus	db	?	; locus of error.
ErrorExtError	dw	?	; extended error code of last error.
ErrorAction	db	?	; suggested action for last error.
ErrorClass	db	?	; class of last error.
ErrorEsDi	dd	?	; ES:DI pointer for last error.
CurrDTA         dd	?	; (!!!) current Disk Transfer Address (far ptr).
CurrPSP         dw	?	; (!!!) seg adr, current program's PSP (0 if none).
		dw	?	; junk area saved during INT 23h (not used).
ProcRetCode	dw	?	; return code from last process termination (4dh).
CurrDrive	db	?	; (!!!) index (from 0) into SDTE table (not an offset).
ExtBreakFlag	db	?	; extended break flag (for DosBreakFlag).
Int21AxValue	dw	?	; value of AX on call to INT 21h.
PspSharingSeg	dw	?	; PSP segment for sharing/network (0).
NetMachineNo	dw	?	; network machine number (0=caller) [Windows requires this].
END_SDA         =	$	; end of the SDA here (see DosServer API).

InWindows	db	?	; 00h=Windows enh mode not running, 01h=running.

;	The following area is reserved for a magic area that Win 3.0 scans
;	but does not use.  Apparently, if the correct data pattern is copied
;	into this buffer, Windows is satisfied and runs.  Sorry for the mess.

MAX_WIN_DATA_SIZE =	2	; maximum size of the reserved area.
WinData         db	MAX_WIN_DATA_SIZE dup (?) ; reserved area for Windows.

;	Scheduler data.

ThreadDatabase	dw	?	; ofs FWA, 1st thread in scheduler database.
ThreadStackSize dw	?	; size of a thread's stack, minus 2.
CurrThread	dw	?	; ofs FWA, currently-running thread.

;	DOS process data.

SysEnvSeg	dw	?	; seg adr, master environment from power on.
SysPSP		dw	?	; seg adr, master PSP.

;	I/O system data.

IoMutex         dw	?	; mutex guarding the data in this section.

PSHT		dw	?	; ofs ptr, System Handle Table in pool.
SHTSIZE         =	256	; 256 entries in the table.

LASTDRIVE	=	'Z'-'A' ; last drive index.
PSDT		dw	?	; ofs ptr, System Drive Table in pool.
SDTSIZE         =	(LASTDRIVE+1) ; up to 26 entries in the drive table.

FSDList         dd	?	; FSD driver chain.
UncFsd		dw	?	; seg FWA, UNCFSD, or 0 if none installed.
DfsFsd		dw	?	; seg FWA, DFSFSD, or 0 if none installed.

;	The DOSCONSTRINPUT Int 21h function uses a system of "template buffers"
;	to keep track of the last input typed by the user in a given situation.
;	The templates are maintained internally by Embedded DOS, and are remembered
;	across invocations of programs, etc.  Whenever a program issues this
;	function, the template list is scanned for a template that is associated
;	with the exact ADDRESS OF THE USER BUFFER (yikes!).  If not found, then
;	the oldest template in the system is reused for purposes of handling
;	the new I/O.

TemplateList	dw	?	; list of Template Buffer Entries (TBE) in pool.

;	Sharing data (retries, etc.) for locks.

ShareRetries	dw	?	; number of retries on sharing violations.
ShareTimeout	dw	?	; number of milliseconds before retries.

;	Fcb system data (conditionally compiled).

		IF	BUILD_FCB
FcbChain	dw	?	; ofs FWA, 1st SFD in system-wide chain.
FcbAvail	dw	?	; number of SFD's that can still be allocated.
FcbMutex	dw	?	; mutex that governs access to the above data.
		ENDIF	; (BUILD_FCB)

;	Other I/O data.

ErrorLog	dw	?		; FWA, 1st error log entry (ELE) in pool.
HostName	dw	?		; FWA, host name, or 0 if none.

;	Here is some incredibly silly code, built into DOSDATA (actually
;	copied during SYSINIT time) that some TSR's look for to find the
;	critical error flag and IN-DOS flag.

TSRCODE_LEN	=	20		; roughly the size of the code.
DynSystemTsrCode db	(TSRCODE_LEN) dup (?) ; copied to by SYSINIT.ASM.

IoTemplates	db	MAX_TEMPLATES*(SIZE TBE) dup (?) ; I/O system templates.

;	<<< ADD MORE DATA ITEMS ABOVE THIS LINE >>>

;	All items in the dynamic segment must come before this word, whose
;	offset is used to calculate the actual size of DOSDATA in bytes at
;	initialization time (SYSINIT.ASM does all this).

		dw	?		; last spare word (EVEN not allowed on MASM6).
EndStaticMem	dw	?		; end of DOS Data segment static data.

;	Stuff after this word is dynamically configured by InitializeData
;	as required by CONFIG.SYS parameters.  This allows tables and the
;	like to be stored in the same segment for addressability.

;	<<< DO NOT ADD LABELS BEYOND THIS POINT.  THIS SPACE IS  >>>
;	<<< AUTOMATICALLY USED BY INITIALIZE_DATA IN SYSINIT.ASM >>>

DOSDATA ENDS


