;***	SFD.INC -- Embedded DOS System FCB Descriptor.
;
;1.	Functional Description.
;	This structure defines the layout of a system FCB descriptor,
;	which is managed by routines in DOSFCBH and chained in a singly-
;	linked list pointed to by FcbChain.  The SFD describes an open
;	instance of a user's FCB, and contains the information the system
;	needs to process I/O requests when submitted directly to the user's
;	FCB, regardless of process context.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

SFD_SIGNATURE	=	1324h		; magic number marks this an an SFD.

SFD		struc
sfd_sig         dw	SFD_SIGNATURE	; always a constant value.
sfd_flags	dw	?		; state of this SFD.
sfd_fcb         dd	?		; FWA, user's FCB (a back pointer).
sfd_handle	dw	?		; system handle, if open.
sfd_fwdlink	dw	?		; ofs FWA, next SFD in chain.
sfd_psp         dw	?		; seg FWA, owning PSP.
sfd_attr	dw	?		; object attributes last noticed.
SFD		ends

SFD_FLAGS_LOCKED	= 0001h         ; SFD is locked (activity in progress).
SFD_FLAGS_HANDLE	= 0002h         ; sfd_handle contains an open system handle.
SFD_FLAGS_EXTENDED	= 0004h         ; SFD points to an extended FCB.
