#!/bin/bash
this_script_dir=$(cd `dirname $0` && pwd)
source_repo_root=$this_script_dir/..

tw_sdk_folder=$source_repo_root/ThingWorx-edge-c-sdk
tw_ldm_lib_folder=$source_repo_root/ThingWorx-ldm-interface-lib
sample_app_folder=$this_script_dir

# By default building ThingWorx:
BUILD_TW=YES

helpFunction()
{
   echo ""
   echo "Usage: $0 -t <YESorNO> -i imageFileName -m MVI56E-lib-folder-name"
   echo -e "\t-t <YESorNO>- Build ThingWorx SDK and sample application"
   echo -e "\t-i <FileName> - use this file instead of regular imagecontents file"
   echo -e "\t-m <FolderName> - name of the folder where MVI56E source code is located. Default value is mvi56e-ldm"
   exit 1 # Exit script after printing help
}

# If arguments are passed, then parse them:
while getopts "t:i:m:h" opt
do
   case "$opt" in
      t ) BUILD_TW="$OPTARG" ;;
      i ) IMAGE_FILE_NAME_ARG="$OPTARG" ;;
	  m ) MVI_LIB_FOLDER_NAME_ARG="$OPTARG" ;;
      h ) helpFunction ;; # Print helpFunction in case parameter is non-existent
   esac
done

if [ -z "$MVI_LIB_FOLDER_NAME_ARG" ]; then
	MVI_LIB_FOLDER_NAME=mvi56e-ldm
else
	MVI_LIB_FOLDER_NAME=$MVI_LIB_FOLDER_NAME_ARG
fi

mvi_folder=$source_repo_root/$MVI_LIB_FOLDER_NAME
LIB_PATH=$mvi_folder/src/lib

# If image contents file name is not defined, then use default one:
if [ -z "$IMAGE_FILE_NAME_ARG" ]; then
IMAGE_FILE_NAME=imagecontents-tw
else
IMAGE_FILE_NAME=$IMAGE_FILE_NAME_ARG
fi

BuildLibs()
{
   LIBS="cgic sysutil"

   for subdir in ${LIBS}
   do
      pushd ${LIB_PATH}/${subdir}
         make
      popd
   done
}

echo build code...

echo .............BUILD libs...................
BuildLibs


if [ "$BUILD_TW" = "YES" ]; then 
	echo Building ThingWorx C Edge SDK ...
	${tw_ldm_lib_folder}/scripts/build-tw-ldm.sh
else
	echo Not building ThingWorx C Edge SDK
fi

echo Building ThingWorx-LDM Library ...
$tw_ldm_lib_folder/scripts/build-lib-ldm.sh


echo Building ThingWorx-LDM Sample Application ...
pushd ${sample_app_folder}
make MVI_LIB_FOLDER_NAME=$MVI_LIB_FOLDER_NAME
popd

pushd ${sample_app_folder}
if [ ! -e firmware ]; then
   echo create firmware directory
   mkdir firmware
fi
echo Building image using image file "$sample_app_folder/$IMAGE_FILE_NAME"
python $mvi_folder/build/LDM/createimage.py ${sample_app_folder}/$IMAGE_FILE_NAME
popd
