/////////////////////////////////////////////////////////////////////////////
//
// ModuleInfo.h
//
// Runtime module info utilities
//
// Copyright (c) 2011, ProSoft Technology, All Rights Reserved
//
//
// DATE     : Aug/09/2011
// MODIFIED :
// Aug/09/2011 HYU - Created
// 10/31/2011 HYU - Added firmwareDate into MODULE_INFO.
// 01/04/2012 HYU - Added the Scan Count into MODULE_INFO.
// 02/23/2012 HYU - Modified MODULE_INFO to make Module Status Data aligned on the word boundaries.
// 08/30/2012 HYU - Changed for wireless.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MODULEINFO_H
#define _MODULEINFO_H



#define   MAX_NAME_LEN     81

#ifndef MAX_REV_INFO
    #define MAX_REV_INFO   500
#endif

#define   MAX_RINFO_SIZE   16

#ifndef   MAX_ENET_RESOURCE
#define   MAX_ENET_RESOURCE  3
#endif

#define   ENET_INFO_IF0      0
#define   ENET_INFO_IF1      1
#define   ENET_INFO_WL0      2

#ifndef   MAX_MAC_SIZE
#define   MAX_MAC_SIZE       6
#endif

#define   MAX_MODULE_CODE_SIZE    6
#define   MAX_VERSION_INFO_SIZE   10
#define   MAX_DATETIME_SIZE       20

#define   MODULE_STATUS_DATA_SIZE 20 // size in words


typedef struct _ENetResourceInfo
{
	char id[MAX_RINFO_SIZE];
	char ip[MAX_RINFO_SIZE];
	char netmask[MAX_RINFO_SIZE];
	char gateway[MAX_RINFO_SIZE];
	unsigned char macAddr[MAX_MAC_SIZE];
}ENetResourceInfo;

typedef struct
{
    unsigned long 		SerialNo;        				//Serial Number
    int					Slot;
    char     			ModuleName[MAX_NAME_LEN];     	//User defined module name (null terminated)
    char     			ProductType[MAX_NAME_LEN];     	//Product Type (null terminated)
    char     			ProductName[MAX_NAME_LEN];     	//Product Name (null terminated)
    unsigned long  		scan_count;
    char     			ProductCode[MAX_MODULE_CODE_SIZE];     	//Null terminated Product code
    char     			ProductRev[MAX_VERSION_INFO_SIZE];     	//Null terminated Product Rev number
    char     			OpRev[MAX_VERSION_INFO_SIZE];       	//Null terminated OS Rev
    char     			OpRun[MAX_VERSION_INFO_SIZE];       	//Null terminated OS Run #
    char     			FirmwareDate[MAX_DATETIME_SIZE];
    char     			Status[MAX_NAME_LEN];
    ENetResourceInfo  	netInfo[MAX_ENET_RESOURCE];

} MODULE_INFO;


int GetModuleInfo(MODULE_INFO* mi);
int ReleaseModuleInfo( void );
int CreateModuleInfo( void );
int RegisterModuleInfo( void );

int SetModuleName(const char * moduleName);
const char * GetModuleName( void );
int SetModuleRunningStatus(const char * status);
void IncModuleScanCount( void );
unsigned long GetModuleScanCount( void );
unsigned short * GetModuleStatusData( void );

int InitModuleInfoRes( OCXHANDLE ocx_handle, WORD vender_id, WORD device_type, WORD product_numeric_code );
void ShowModuleInfo( void );

#endif
