#ifndef FIRMWAREHEADER_H_
#define FIRMWAREHEADER_H_


#define PROSOFT_FIRMWARE_FILE_NAME  "Prosoft Technology Firmware File."
#define PROSOFT_FIRMWARE_FILE_NAME_LENGTH  33
#define PROSOFT_PRODUCT_TYPE_LENGTH  50
#define PROSOFT_VERSION_LENGTH  8

//#define HASH_SEED "PROSOFT@@$$!!\x04\x09\x05\x0A\x04\x09"



struct psftFirmwareHeader {
	char prosoftFileName[PROSOFT_FIRMWARE_FILE_NAME_LENGTH]; // File Header
	char productType[PROSOFT_PRODUCT_TYPE_LENGTH];
	char version[8]; // Version Human generated
	char year[4];    // Year Auto Generated
	char month[2];   // Month Auto Generated
	char day[2];     // Day Auto Generated
	char hour[2];    // Hour Auto Generated
	char min[2];     // Min Auto Generated
	char sec[2];     // Sec Auto Generated
	unsigned char digest[20]; // Hash for the file
	char reserved[100]; // reserved but not stored in file
};

#define PROSOFT_FIRMWARE_HEADER_LENGTH 200

#endif /*FIRMWAREHEADER_H_*/
