#!/bin/bash
# Folder where this script is located:
script_dir=$(cd `dirname $0` && pwd)

build_folder=build/ldm/Release
root_dir=$script_dir/../..
tw_dir=$root_dir/ThingWorx-edge-c-sdk

export PST_TOOLCHAIN_DIR="/opt/timesys/datm3/toolchain"
export PST_BUILD_DIR="$tw_dir/$build_folder"
export THINGWORX_CSDK_OPENSSL_INCLUDE_DIR="$PST_TOOLCHAIN_DIR/include"

#Folder with libraries is not folder with actual files, it is temporary folder with symbolic links to real files:
export THINGWORX_CSDK_OPENSSL_LIB_DIR="$PST_BUILD_DIR/lib"

if [ -f $root_dir/cJSON/cJSON.h ]; then
	if [ -f $root_dir/cJSON/cJSON.c ]; then
		cp -f $root_dir/cJSON/cJSON.c $tw_dir/src/thirdParty/cJSON/
		cp -f $root_dir/cJSON/cJSON.h $tw_dir/src/thirdParty/cJSON/
		cp -f $root_dir/cJSON/CHANGELOG.md $tw_dir/src/thirdParty/cJSON/
		cp -f $root_dir/cJSON/LICENSE $tw_dir/src/thirdParty/cJSON/
	fi
fi

# If source code exists, then build it from source code.
if [ -f $tw_dir/src/CMakeLists.txt ]; then
echo "File [$tw_dir/src/CMakeLists.txt] does exist, assuming that ThingWorx C Edge SDK source code is present, building it from source code now."
# If build folder does not exist, create it. Is exists, clean it:
pushd $tw_dir
if [ -f $build_folder/CMakeCache.txt ]; then
rm $build_folder/CMakeCache.txt
fi
if ! [ -d $build_folder ]; then
mkdir -p $build_folder
fi
popd

# If folder to store symbolic links to OpenSSL libraries does not exist, then create it:
if ! [ -d $THINGWORX_CSDK_OPENSSL_LIB_DIR ]; then
pushd $PST_BUILD_DIR
mkdir lib
popd
fi

# Create symbolic links to OpenSSL library files (with version as expected by ThingWorx):
[ -f $THINGWORX_CSDK_OPENSSL_LIB_DIR/libssl.so.1.0.0 ] || ln -s $PST_TOOLCHAIN_DIR/lib/libssl.so.0.9.8 $THINGWORX_CSDK_OPENSSL_LIB_DIR/libssl.so.1.0.0
[ -f $THINGWORX_CSDK_OPENSSL_LIB_DIR/libcrypto.so.1.0.0 ] || ln -s $PST_TOOLCHAIN_DIR/lib/libcrypto.so.0.9.8 $THINGWORX_CSDK_OPENSSL_LIB_DIR/libcrypto.so.1.0.0

[ -f $THINGWORX_CSDK_OPENSSL_LIB_DIR/libssl.so ] || ln -s $PST_TOOLCHAIN_DIR/lib/libssl.so.0.9.8 $THINGWORX_CSDK_OPENSSL_LIB_DIR/libssl.so
[ -f $THINGWORX_CSDK_OPENSSL_LIB_DIR/libcrypto.so ] || ln -s $PST_TOOLCHAIN_DIR/lib/libcrypto.so.0.9.8 $THINGWORX_CSDK_OPENSSL_LIB_DIR/libcrypto.so


pushd $PST_BUILD_DIR
echo "******* Building ThingWorx Edge SDK with CMake ****"
cmake -DCMAKE_TOOLCHAIN_FILE=$script_dir/LDM-toolchain.txt $tw_dir
echo "******* Building ThingWorx Edge SDK with make ****"
make
if [ -f $PST_BUILD_DIR/src/libtwCSdk_static.a ]; then
 mv -f $PST_BUILD_DIR/src/libtwCSdk_static.a  $PST_BUILD_DIR/libtwCSdk_static.a
fi

if [ -f $PST_BUILD_DIR/src/libtwCSdk.so.2.2.1 ]; then
 mv -f $PST_BUILD_DIR/src/libtwCSdk.so.2.2.1  $PST_BUILD_DIR/libtwCSdk.so.2.2.1
fi

if [ -f $PST_BUILD_DIR/libtwCSdk.so ]; then
	rm $PST_BUILD_DIR/libtwCSdk.so
fi

if [ -f $PST_BUILD_DIR/libtwCSdk.so.2.2.1 ]; then
 ln -s $PST_BUILD_DIR/libtwCSdk.so.2.2.1 $PST_BUILD_DIR/libtwCSdk.so
fi

if [ -d $PST_BUILD_DIR/src ]; then rm -r $PST_BUILD_DIR/src; fi

popd

else
	echo "File [$tw_dir/src/CMakeLists.txt] does not exist, assuming that no source code for ThingWorx C Edge SDK is present"
	tw_lib_detected="no"
	if [ -f $tw_dir/$build_folder/libtwCSdk.so ]; then
		echo "ThingWorx SDK shared library detected"
		tw_lib_detected="yes"
	fi
	if [ -f $tw_dir/$build_folder/libtwCSdk_static.a ]; then
		echo "ThingWorx SDK static library detected"
		tw_lib_detected="yes"
	fi

	if [ "$tw_lib_detected" == "no" ]; then
		echo "ThingWorx SDK library is not detected."
	fi	
fi
