;***	DOSAPI.INC -- DOS API Definitions for Assembly Language.
;
;1.	Functional Description.
;	This include file defines function codes for the INT 21h API.
;	Status codes are int DOSERR.INC.
;
;2.	Modification History.
;	S. E. Jones	92/09/04.	#1.100, consolidated defines here.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

DOSTERMINATE	=	0		; terminate program.
DOSCONINPUT	=	1		; read console character with echo.
DOSCONOUTPUT	=	2		; write character to console.
DOSAUXINPUT	=	3		; read from AUX device.
DOSAUXOUTPUT	=	4		; write to AUX device.
DOSPRNOUTPUT	=	5		; write to PRN device.
DOSCONIO	=	6		; read/write to console (direct).
DOSCONINPUTRAW	=	7		; read raw console char without echo.
DOSCONINPUTRAW2 =	8		; read raw console char without echo.
DOSCONSTROUTPUT =	9		; write string to console.
DOSCONSTRINPUT	=	0ah		; read string from console.
DOSCONGETSTATUS =	0bh		; get status of input buffer.
DOSCONFLUSH	=	0ch		; flush input buffer & exec command.
DOSDISKRESET	=	0dh		; reset diskette subsystem.
DOSSETDEFAULTDRIVE =	0eh		; set default drive number.
DOSOPENFCB	=	0fh		; open file using FCB.
DOSCLOSEFCB	=	10h		; close file using FCB.
DOSFINDFIRSTFCB =	11h		; find first match using FCB.
DOSFINDNEXTFCB	=	12h		; find next match using FCB.
DOSDELETEFCB	=	13h		; delete file using FCB.
DOSREADFCB	=	14h		; sequential file read using FCB.
DOSWRITEFCB	=	15h		; sequential file write using FCB.
DOSCREATEFCB	=	16h		; create file using FCB.
DOSRENAMEFCB	=	17h		; rename file using FCB.
DOSGETLOGIN	=	18h		; return login vector (CP/M compatibility).
DOSGETDEFAULTDRIVE =	19h		; get default drive using FCB.
DOSSETDTA	=	1ah		; set disk transfer address for FCB.
DOSGETDEFAULTINFO =	1bh		; get allocation info for default drive.
DOSGETINFO	=	1ch		; get allocation info for specific drive.
DOSGETREADONLYVECTOR =	1dh		; get R/O vector (CP/M compatibility).
DOSSETFILEATTRIBUTES =	1eh		; set file attr (CP/M compatibility).
DOSGETDEFAULTDPB =	1fh		; get ptr to default DPB.
DOSUSERCODE	=	20h		; get/set user code (CP/M compatibility).
DOSRANDOMREADFCB =	21h		; random read on FCB.
DOSRANDOMWRITEFCB =	22h		; random write on FCB.
DOSGETFILESIZEFCB =	23h		; get size of file on FCB.
DOSSETRANDOMRECFCB =	24h		; set random record position on FCB.
DOSSETVECTOR	=	25h		; set interrupt vector.
DOSCREATEPSP	=	26h		; create program segment prefix.
DOSRANDOMREADBLKFCB =	27h		; random read (block I/O) on FCB.
DOSRANDOMWRITEBLKFCB =	28h		; random write (block I/O) on FCB.
DOSPARSEFILENAME =	29h		; parse filename in FCB.
DOSGETDATE	=	2ah		; get system date.
DOSSETDATE	=	2bh		; set system date.
DOSGETTIME	=	2ch		; get system time.
DOSSETTIME	=	2dh		; set system time.
DOSSETVERIFY	=	2eh		; set disk I/O verify mode on or off.
DOSGETDTA	=	2fh		; get disk transfer address.
DOSGETVERSION	=	30h		; get MS-DOS compatibility version #.
DOSTSR		=	31h		; terminate and stay resident in memory.
DOSGETDPB	=	32h		; get ptr to DPB.
DOSBREAKFLAG	=	33h		; get/set break flag for Ctrl-C.
DOSGETVAR	=	34h		; get DOS variables address.
DOSGETVECTOR	=	35h		; get interrupt vector.
DOSGETDISKFREE	=	36h		; get disk free space.
DOSSWITCHAR	=	37h		; get/set switch character.
DOSCOUNTRYINFO	=	38h		; get/set country information.
DOSCREATEDIR	=	39h		; create subdirectory.
DOSDELETEDIR	=	3ah		; delete subdirectory.
DOSSETDIR	=	3bh		; set current directory.
DOSCREATE	=	3ch		; create or truncate file.
DOSOPEN         =	3dh		; open file or device.
DOSCLOSE	=	3eh		; close handle to file or device.
DOSREAD         =	3fh		; read file or device.
DOSWRITE	=	40h		; write file or device.
DOSDELETE	=	41h		; delete file.
DOSSETPOS	=	42h		; set file pointer position.
DOSFILEATTR	=	43h		; get/set file attributes.
DOSDEVIOCTL	=	44h		; general device I/O control.
DOSDUPLICATE	=	45h		; duplicate handle.
DOSFORCEDUPLICATE =	46h		; force duplicate handle.
DOSGETDIR	=	47h		; get current directory.
DOSALLOCSEG	=	48h		; allocate memory segment.
DOSFREESEG	=	49h		; free memory segment.
DOSSIZESEG	=	4ah		; change size of memory segment.
DOSEXEC         =	4bh		; load/execute program/overlay.
DOSEXIT         =	4ch		; terminate process.
DOSWAIT         =	4dh		; wait for process to get return code.
DOSFINDFIRST	=	4eh		; find first file in pattern.
DOSFINDNEXT	=	4fh		; find next file in pattern.
DOSSETPSP	=	50h		; set current PSP.
DOSGETPSP	=	51h		; get current PSP.
DOSGETANCHOR	=	52h		; get anchor block.
DOSBPBTODPB	=	53h		; convert BPB to DPB.
DOSGETVERIFY	=	54h		; get verify flag status.
DOSDUPPSP	=	55h		; duplicate current PSP for DOSEXEC.
DOSRENAME	=	56h		; rename file.
DOSTIMESTAMP	=	57h		; get/set file date/time stamp.
DOSALLOCSTRAT	=	58h		; get/set memory allocation strategy.
DOSGETEXTERROR	=	59h		; get extended error information.
DOSCREATETEMPFILE =	5ah		; create a temporary file.
DOSCREATENEWFILE =	5bh		; create a new file.
DOSLOCK         =	5ch		; lock/unlock byte range in file.
DOSMSNET	=	5dh		; MS-NET support.
DOSMACHINEINFO	=	5eh		; get/set machine name/printer setup.
DOSNETWORK	=	5fh		; perform network operations.
DOSCANONICALIZEPATH =	60h		; canonicalize object pathname.
DOSGETPSP	=	62h		; get program segment prefix.
DOSGETLEADBYTETBL =	63h		; get lead byte table (not in 3.x).
DOSGETEXTCOUNTRYINFO =	65h		; get extended country information.
DOSGETSETCODEPAGE =	66h		; get or set the current code page.
DOSSETHANDLELIMIT =	67h		; set the max. # of handles/curr process.
DOSCOMMITFILE =         68h		; commit file to disk.
DOSALERT	=	70h		; issue alert box and return response.

;	DOSDEVIOCTL subfunction codes.

IOCTL_GET_DEV_INFO =	0		; get device information (2.0).
IOCTL_SET_DEV_INFO =	1		; set device information (2.0).
IOCTL_READ_CHARDEV =	2		; read control data from char. device (2.0).
IOCTL_WRITE_CHARDEV =	3		; write control data to char device (2.0).
IOCTL_READ_BLKDEV =	4		; read control data from block device (2.0).
IOCTL_WRITE_BLKDEV =	5		; write control data to block device (2.0).
IOCTL_CHECK_INPUT_STATUS = 6		; check input status (2.0).
IOCTL_CHECK_OUTPUT_STATUS = 7		; check output status (2.0).
IOCTL_CHECK_REMOVABLE = 8		; check if block device is removable (3.0).
IOCTL_CHECK_REMOTE =	9		; check if block device is remote (3.1).
IOCTL_CHECK_HANDLE_REMOTE = 10		; check if handle is remote (3.1).
IOCTL_CHANGE_SHARE_RETRY = 11		; change sharing retry count (3.1).
IOCTL_GENERIC_CHARDEV = 12		; generic I/O control for char devices (3.2).
IOCTL_GENERIC_BLKDEV = 13		; generic I/O control for block devices (3.2).
IOCTL_GET_LOGICAL_DRIVE_MAP = 14	; get logical drive map (3.2).
IOCTL_SET_LOGICAL_DRIVE_MAP = 15	; set logical drive map (3.2).
IOCTL_FSCTL = 16			; file system driver control (Embedded DOS only).
IOCTL_LIMIT = IOCTL_FSCTL		; maximum function code.

;	Open access modes.

OPEN_MODE_READ	=	0		; open for reading only.
OPEN_MODE_WRITE =	1		; open for writing only.
OPEN_MODE_READ_WRITE =	2		; open for both reading and writing.

;	Open sharing modes (0xxx0000b), shifted to the right 4 bits.

OPEN_MODE_COMPATIBILITY = 0		; special, for FCBs.
OPEN_MODE_DENY_ALL	= 1		; nobody else can open the file.
OPEN_MODE_DENY_WRITE	= 2		; nobody else can write to the file.
OPEN_MODE_DENY_READ	= 3		; nobody else can read from the file.
OPEN_MODE_DENY_NONE	= 4		; anyone can do anything else.

;	High bit of open sharing/access mode byte is set if the handle
;	should NOT be inherited.  Here is the bit that controls NON-INHERITANCE.

OPEN_MODE_NO_INHERIT	= 80h		; handle should not be inherited.

;	Seek method codes.

SEEK_MODE_BOF	=	0		; seek from beginning of file.
SEEK_MODE_REL	=	1		; seek relative to current position.
SEEK_MODE_EOF	=	2		; seek from end of file.

;	File creation attributes (DosCreate).  These are bitflags.

CREATE_ATTRIBUTE_NORMAL   =	0	; file is normal.
CREATE_ATTRIBUTE_READONLY =	0001h	; file will be made read only.
CREATE_ATTRIBUTE_HIDDEN   =	0002h	; file will be made hidden.
CREATE_ATTRIBUTE_SYSTEM   =	0004h	; file will be marked SYSTEM.
CREATE_ATTRIBUTE_NEW	  =	8000h	; don't overwrite existing file.

;	Image activator subfunction codes.

EXEC_EXECUTE_IMAGE =	0		; load and execute program image.
EXEC_LOAD_IMAGE =	1		; load program image only.
EXEC_LOAD_OVERLAY =	3		; load overlay image.

;	Termination codes returned by DOSWAIT.

WAIT_NORMAL	=	0		; normal termination.
WAIT_CTRLC	=	1		; termination by CTRL-C.
WAIT_CRITERR	=	2		; termination by critical device error.
WAIT_FUNC31	=	3		; term. by call to function 31h (TSR).
