;***	DPB.INC -- Embedded DOS Drive Parameter Block.
;
;1.	Functional Description.
;	This structure defines the layout of a drive parameter block as
;	returned by DosGetDpb and DosGetDefaultDpb in the INT 21h API.
;	This layout was derived from the May 1986 issue of PC Tech Journal,
;	pages 112-150.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;	S. E. Jones	96/04/10.	#6-XL v46, added DOS 5.0 fields for CARDSOFT.
;
;3.	NOTICE: Copyright (C) 1990-1996 General Software, Inc.

DPB		struc
dpb_drive	db	?		; index into SDT (0=A:, 1=B:, etc.).
dpb_unit	db	?		; unit number passed to driver.
dpb_bps         dw	?		; bytes per sector (512).
dpb_spc         db	?		; sectors per cluster (actually SPC-1).
dpb_shift	db	?		; cluster to sector shift count.
dpb_rs		dw	?		; reserved sectors.
dpb_nfat	db	?		; number of FATs.
dpb_mde         dw	?		; maximum directory entries.
dpb_da		dw	?		; 1st data sector relative to partition.
dpb_tcc         dw	?		; total cluster count, plus 1.
dpb_spf         dw	?		; sectors per FAT (was byte in 3.31).
dpb_rootdir	dw	?		; 1st root directory sector rel. to partition.
dpb_dev         dd	?		; FWA, device driver header.
dpb_md		db	?		; media descriptor byte.
dpb_access	db	?		; accessed byte (0 if disk has been accessed).
dpb_fwdlink	dd	?		; FWA, next DPB in chain, or ffff:ffff if EOF.
dpb_free	dw	?		; DOS 5.0 & up: last allocated cluster.
dpb_nfree	dw	?		; DOS 5.0 & up: number of free clusters.
DPB		ends
