;***	FLR.INC -- Embedded DOS FAT Lock Record.
;
;1.	Functional Description.
;	This structure maintains the state for a lock on a FAT file object
;	managed by the FAT FSD.  These lock records are chained together
;	in a linked list managed by FATHLP.ASM, and are managed by the
;	FatLock and FatUnlock routines.  FatReadFile and FatWriteFile
;	calls ensure that I/O is allowed by the lock list.
;
;2.	Modification History.
;	S. E. Jones	90/11/24.	Added record locking.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;	S. E. Jones	95/05/04.	#6-XL v28, changed start to dirsec/dirofs.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

FLR		struc
flr_fwdlink	dw	?		; offset ptr, next FLR in chain.

;	The following fields uniquely define this file's cluster chain.

flr_dirsec	dd	?		; directory sector number for file.
flr_dirofs	dw	?		; directory sector offset for file.

flr_sdte	dw	?		; FWA, SDTE for drive containing file.

;	The following fields maintain the lock's position and size in the file.

flr_ptr         dd	?		; starting byte offset of locked region.
flr_len         dd	?		; length of locked region in bytes.
FLR		ends
