;***	MACROS.INC -- Embedded DOS MACRO Definitions.
;
;1.	Functional Description.
;	This include file contains definitions for macros used in
;	General Software assembly-level products.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/07/26.	#1.087, optimized DBGSYS macro.
;	S. E. Jones	91/08/09.	#1.090, removed gurus.
;	S. E. Jones	91/08/11.	#1.090, fixed DS/reg bug in USEDGROUP.
;	S. E. Jones	91/11/19.	#1.094, added long thread allocator.
;	S. E. Jones	92/01/02.	#1.094, added MASM 510 & above checking.
;	S. E. Jones	92/01/06.	#1.095, FREE->DEALLOCATE in SYS_xxx.
;	S. E. Jones	92/12/18.	#1.101, added SYSEVENT macro.
;	S. E. Jones	93/09/10.	#1.106, TASM: DISPLAY->DISPLAYSTR macro.
;	S. E. Jones	93/09/10.	#1.106, TASM: Pcall split up.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;	C. S. Rhodes	95/02/10.	#2.2, removed references to DEBUG.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

;***	Module - Declares a Kernel Module.
;
;	This macro is called at the beginning of each module but after
;	the includes to define symbols as required to make the rest of
;	the macros in this package work correctly.

Module	MACRO modname, codesegname, kerflag
	IFIDNI	<kerflag>,<BOUND>
CGROUP_MODULE	=   1			; 1==>cgroup, 0==>other.
	ELSE
CGROUP_MODULE	=   0
	ENDIF
	ENDM

;***	Global - Define a global variable.
;
Global	MACRO	name, type, initvalue
	IFDEF	SYSINITDATA
	IFIDNI	<type>,<BYTE>
name	db	initvalue
	ELSE
	IFIDNI	<type>,<WORD>
name	dw	initvalue
	ELSE
	IFIDNI	<type>,<DWORD>
name	dd	initvalue
	ELSE
	.ERR
	%out	wrong type, should be BYTE, WORD, or DWORD.
	ENDIF
	ENDIF
	ENDIF
	PUBLIC	name
	ELSE
	EXTRN	name:type
	ENDIF
	ENDM

LJA	MACRO	lab
	LOCAL	lja_biff
	jna	lja_biff
	jmp	lab
lja_biff:
	ENDM

LJAE	MACRO	lab
	LOCAL	ljae_biff
	jb	ljae_biff
	jmp	lab
ljae_biff:
	ENDM

LJBE	MACRO	lab
	LOCAL	ljbe_biff
	ja	ljbe_biff
	jmp	lab
ljbe_biff:
	ENDM

LJB	MACRO	lab
	LOCAL	ljb_biff
	jnb	ljb_biff
	jmp	lab
ljb_biff:
	ENDM

LJZ	MACRO	lab
	LOCAL	ljz_biff
	jnz	ljz_biff
	jmp	lab
ljz_biff:
	ENDM

LJNZ	MACRO	lab
	LOCAL	ljnz_biff
	jz	ljnz_biff
	jmp	lab
ljnz_biff:
	ENDM

LJE	MACRO	lab
	LOCAL	lje_biff
	jne	lje_biff
	jmp	lab
lje_biff:
	ENDM

LJNE	MACRO	lab
	LOCAL	ljne_biff
	je	ljne_biff
	jmp	lab
ljne_biff:
	ENDM

LJC	MACRO	lab
	LOCAL	ljc_biff
	jnc	ljc_biff
	jmp	lab
ljc_biff:
	ENDM

LJNC	MACRO	lab
	LOCAL	ljnc_biff
	jc	ljnc_biff
	jmp	lab
ljnc_biff:
	ENDM

Longword	struc
lo		dw	?
hi		dw	?
Longword	ends

;***	DISABLE - Disable Interrupts.
;

DISABLE MACRO
	cli
	ENDM

;***	ENABLE - Enable Interrupts.
;

ENABLE	MACRO
	sti
	ENDM

;***	DefProc - Define subroutine entrypoint.
;
;	This macro takes two optional arguments, which can be interchanged
;	now, but may require an ordering later.  So here is the format.
;	If you want to declare a procedure, use this macro.  By default,
;	the procedure will be NEAR.  If you want the near procedure to
;	be publicly-known, then add ",PUBLIC" as an operand.  If you want
;	a FAR procedure instead, then use ",FAR" as an operand.  If you
;	also want that FAR procedure to be publicly-known, then add ",PUBLIC"
;	to the ",FAR" operand.

DefProc MACRO	name, scope, visibility
	IFIDNI	<scope>, <PUBLIC>
	PUBLIC	name
	ENDIF

	IFIDNI	<visibility>, <PUBLIC>
	PUBLIC	name
	ENDIF

	IFIDNI	<scope>, <FAR>
name	PROC	FAR
	ELSE
	IFIDNI	<visibility>, <FAR>
name	PROC	FAR
	ELSE
name	PROC	NEAR
	ENDIF
	ENDIF
	ENDM

;***	EndProc - Mark end of subroutine definition.
;

EndProc MACRO	name
	ret			; just in case he doesn't bother.
	ASSUME	NOTHING
name	ENDP
	ENDM

;***	MsPcall - Call local or external procedure.
;

MsPcall MACRO	name, scope
	IFIDNI	<scope>, <FAR>

	IFNDEF	name
	EXTRN	name:FAR
	ENDIF

	ELSE

	IFE	(@Version-510)		; if version == MASM 510, then...
	IF2
	IFNDEF	name
	EXTRN	name:NEAR
	ENDIF
	ENDIF
	ELSE
	IFNDEF	name
	EXTERNDEF name:NEAR		; for MASM 6.0 and above.
	ENDIF
	ENDIF

	ENDIF

	call	name
	ENDM

;***	BorPcall - Call local or external procedure.
;

BorPcall MACRO	name, scope
	IFIDNI	<scope>, <FAR>
	IFNDEF	name
	GLOBAL	name:FAR
	ENDIF
	ELSE
	IFNDEF	name
	GLOBAL	name:NEAR
	ENDIF
	ENDIF
	call	name
	ENDM

;***	Pcall - Call local or external procedure.
;

Pcall	MACRO	name, scope
	IFDEF	BORLAND
	BorPcall name, scope
	ELSE
	MsPcall name, scope
	ENDIF	; (IFDEF ??Version -- only Borland defines this)
	ENDM

;***	DefInterrupt - Define software interrupt handler.
;

DefInterrupt MACRO name
	PUBLIC	name
name	PROC	FAR		; all transfers are FAR.
	ENDM

;***	EndInterrupt - Mark end of software interrupt handler.
;

EndInterrupt MACRO name
	iret			; just in case he doesn't bother.
	ASSUME	NOTHING
name	ENDP
	ENDM

;***	SYSEVENT - Log system event inside kernel.
;
;	Records an event to the system log.

SYSEVENT MACRO	eventcode
	push	bp
	mov	bp, eventcode
	int	SYSEVENTINT
	pop	bp
	ENDM

;***	TASKING - guarded critical section control.
;
;	Usage:		TASKING ON	; resume multitasking.
;			TASKING OFF	; suspend multitasking.
;
;	Critical sections can nest up to 65535 times.

TASKING MACRO	action
	IFIDNI	<action>,<ON>
	  Pcall   SysLeaveCriticalSection
	  EXITM
	ENDIF
	IFIDNI	<action>,<OFF>
	  Pcall   SysEnterCriticalSection
	  EXITM
	ENDIF
	%out	Bogus TASKING macro has bad operand: %action
	ENDM

;***	AllocatePool - Allocate Memory From System Pool.
;
;	This macro is used to allocate a chunk of memory from a system
;	pool that user programs cannot fiddle with.  Allocation can be
;	performed at interrupt time on the fly, and is very fast, so
;	this is the kind of memory that should be used for temporary
;	fast work areas.  The memory is always relative to DOSDATA.
;	If successful, the result is returned in DI.  If CY is set
;	on exit, then the call failed.	Otherwise, it succeeded.
;
;	Usage:		AllocatePool  POOLSIZE

AllocatePool MACRO chunksize
	IFIDNI	<chunksize>,<ax>

	push	dx
	mov	dl, SYS_ALLOCATE_POOL
	int	SYSINT
	pop	dx

	ELSE

	push	ax
	push	dx
	mov	ax, chunksize
	mov	dl, SYS_ALLOCATE_POOL
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax

	ENDIF
	ENDM

;***	DeallocatePool - Return Memory To System Pool.
;
;	This macro is used to free a chunk of memory back to the system
;	pool that user programs cannot fiddle with.  Deallocation can be
;	performed at interrupt time on the fly, and is very fast, so
;	this is the kind of memory that should be used for temporary
;	fast work areas.  The memory is always relative to DOSDATA.
;	This macro always assumes the memory is pointed to by DI.
;
;	Usage:		DeallocatePool

DeallocatePool MACRO
	push	dx
	mov	dl, SYS_DEALLOCATE_POOL
	int	SYSINT			; call system kernel function.
	pop	dx
	ENDM

;***	KeepPool - Keep Memory (Maintain Extra Reference).
;
;	This macro is used to increment the reference count on a chunk
;	of pool memory so that the next FreePool doesn't actually dispose
;	of it.	The memory is always relative to DOSDATA.  This macro
;	always assumes the memory is pointed to by DI.
;
;	Usage:		KeepPool

KeepPool MACRO
	push	dx
	mov	dl, SYS_KEEP_POOL
	int	SYSINT			; call system kernel function.
	pop	dx
	ENDM

;***	AllocateSpinLock - Allocate Spin (short term) Lock Object.
;
;	This macro is used to allocate a spin lock and store its handle
;	in a specified location.  In the actual implementation, this
;	macro doesn't even call a package, but resets a spinlock to
;	a known state.	The place where we store the handle IS the spinlock.
;
;	Usage:		AllocateSpinLock lock

AllocateSpinLock MACRO lck
	mov	lck, 0			; initialize the lock.
	ENDM

;***	DeallocateSpinLock - Deallocate Spin (short term) Lock Object.
;
;	This macro is used to deallocate a spin lock and return it
;	to the system.	In this implementation, since the user's
;	handle storage actually serves as the lock itself, we don't
;	do anything here at all.  If we change the implementation,
;	then the source can just be recompiled and the FreeSpinLock
;	calls will do something meaningful, like deallocating pool.
;
;	Usage:		DeallocateSpinLock lock

DeallocateSpinLock MACRO lck
	mov	lck, 0			; reset the lock.
	ENDM

;***	AcquireSpinLock - Acquire Spin (short term) Lock.
;
;	This macro is used to acquire a spin lock in a multiprocessor system
;	so that access to a mutually-exclusive object can be controlled in
;	an MP-safe way.  To setup a spinlock, initialize it with the
;	ALLOCATELOCK macro.  Then to acquire the lock, use this macro.
;	to free up the lock when you're done, use the RELEASELOCK macro.
;
;	Usage:		AcquireSpinLock lock [, scratch-reg]

AcquireSpinLock MACRO lck, scr
	IF	MULTIPROCESSOR
	IFIDN	<scr>,<>

	push	ax
	IF	ASSERTS
	IF	CGROUP_MODULE
	mov	ax, lck                 ; (AX) = contents of spinlock.
	Pcall	AssertLock		; check lock to see if it's acquired.
	ENDIF	; (CGROUP_MODULE)
	ENDIF	; (ASSERTS)
	mov	ax, 1
@@:	xchg	lck, ax                 ; SOME ARCHITECTURES NEED A LOCK PREFIX HERE.
	or	ax, ax
	jnz	@b
	pop	ax

	ELSE

	IF	ASSERTS
	IF	CGROUP_MODULE
	push	ax
	mov	ax, lck                 ; (AX) = contents of spinlock.
	Pcall	AssertLock		; check lock to see if it's acquired.
	pop	ax
	ENDIF	; (CGROUP_MODULE)
	ENDIF	; (ASSERTS)

	mov	scr, 1
@@:	xchg	lck, scr		; SOME ARCHITECTURES NEED A LOCK PREFIX HERE.
	or	scr, scr
	jnz	@b

	ENDIF
	ENDIF
	ENDM

;***	ReleaseSpinLock - Release Spin (short term) Lock.
;
;	This macro is used to release a spin lock in a multiprocessor system
;	so that access to a mutually-exclusive object can be controlled in
;	an MP-safe way.  To setup a spinlock, initialize it with the
;	INITIALIZELOCK macro.  To acquire the lock, use ACQUIRELOCK.  To
;	free up the lock when you're done, use the RELEASELOCK macro.
;
;	Usage:		ReleaseSpinLock lock

ReleaseSpinLock MACRO lck
	IF	MULTIPROCESSOR
	mov	lck, 0
	ENDIF
	ENDM

;***	AllocateMutex - Allocate a Mutex (long term) Lock.
;
;	This macro is used to allocate a mutex object and return a
;	handle to it.  The macro stores the mutex handle into the
;	specified location.
;
;	Usage:		AllocateMutex mutex

AllocateMutex MACRO mutex
	push	ax
	push	dx
	mov	dl, SYS_ALLOCATE_MUTEX	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	mov	mutex, ax		; store handle to mutex object.
	pop	dx
	pop	ax
	ENDM

;***	DeallocateMutex - Free a Mutex (long term) Lock.
;
;	This macro is used to deallocate a mutex object and return it
;	to the system.
;
;	Usage:		DeallocateMutex mutex

DeallocateMutex MACRO mutex
	push	ax
	push	dx
	mov	ax, mutex		; (AX) = handle to mutex object.
	mov	dl, SYS_DEALLOCATE_MUTEX; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	AcquireMutex - Acquire Mutex (long term) Lock.
;
;	This macro is used to acquire exclusive access to a mutex object.
;
;	Usage:		AcquireMutex mutex

AcquireMutex MACRO mutex
	push	ax
	push	dx
	mov	ax, mutex		; (AX) = handle to mutex object.
	mov	dl, SYS_ACQUIRE_MUTEX	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	ReleaseMutex - Release Mutex (long term) Lock.
;
;	This macro is used to release exclusive access to a mutex object.
;
;	Usage:		ReleaseMutex mutex

ReleaseMutex MACRO mutex
	push	ax
	push	dx
	mov	ax, mutex		; (AX) = handle to mutex object.
	mov	dl, SYS_RELEASE_MUTEX	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	AllocateEvent - Allocate an Event Object.
;
;	This macro is used to allocate an event object and return a
;	handle to it.  The macro stores the event handle into the
;	specified location.
;
;	Usage:		AllocateEvent event

AllocateEvent MACRO event
	push	ax
	push	dx
	mov	dl, SYS_ALLOCATE_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	mov	event, ax		; store handle to event object.
	pop	dx
	pop	ax
	ENDM

;***	DeallocateEvent - Free an Event Object.
;
;	This macro is used to deallocate an event object and return it
;	to the system.
;
;	Usage:		DeallocateEvent event

DeallocateEvent MACRO event
	push	ax
	push	dx
	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_DEALLOCATE_EVENT; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	SetEvent - Transition Event Object to SET State.
;
;	This macro is used to set an event object.
;
;	Usage:		SetEvent event

SetEvent MACRO	event
	push	ax
	push	dx
	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_SET_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;MVIMOD jmc 11/17/99
;***	SetEventIsr - Transition Event Object to SET State from within ISR.
;
;	This macro is used to set an event object from within an ISR.
;
;	Usage:		SetEventIsr event

SetEventIsr MACRO	event
	push	ax
	push	dx
	mov	ax, event		; (AX) = handle to event object.
	mov	dl, OEM_SET_EVENT_ISR	; (DL) = SYSINT function code.
	int	SYSINTALT		; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	ClearEvent - Transition Event Object to CLEARED State.
;
;	This macro is used to clear an event object.
;
;	Usage:		ClearEvent event

ClearEvent MACRO event
	push	ax
	push	dx
	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_CLEAR_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	PulseEvent - Momentarily Transition Event Object to SET State.
;
;	This macro is used to pulse an event object.
;
;	Usage:		PulseEvent event

PulseEvent MACRO event
	push	ax
	push	dx
	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_PULSE_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	WaitEvent - Wait On Event Object.
;
;	This macro is used to wait for an event to transition to the set
;	state.	If the event is already set at the time the wait is issued,
;	then execution continues as though the event became set during the wait.
;
;	Usage:		WaitEvent event

WaitEvent MACRO event
	push	ax
	push	dx
	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_WAIT_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	QueryEvent - Query Event Object.
;
;	This macro is used to return the state of an event object.
;
;	Usage:		QueryEvent event, state

QueryEvent MACRO event, state
	push	ax
	push	dx
	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_QUERY_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	mov	state, ax		; store the result.
	pop	dx
	pop	ax
	ENDM

;***	AllocateThread - Allocate a Thread Object.
;
;	This macro is used to allocate a thread object and begin
;	its execution at the specified location.
;
;	Usage:		AllocateThread label

AllocateThread MACRO lab
	push	ax
	push	cx
	push	dx
	lea	ax, lab                 ; (AX) = FWA, CS-relative execution stream.
	mov	cx, cs			; (CX:AX) = FWA, execution stream.
	mov	dl, SYS_ALLOCATE_THREAD ; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	cx
	pop	ax
	ENDM

;***	DeallocateThread - Free a Thread Object.
;
;	This macro is used to deallocate a thread object and return it
;	to the system.	A thread can only call FreeThread on itself.
;
;	Usage:		DeallocateThread

DeallocateThread MACRO
	mov	dl, SYS_DEALLOCATE_THREAD ; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	ENDM

;***	AllocateThreadLong - Allocate a Thread Object With More Options.
;
;	This macro is used to allocate a thread object and begin
;	its execution with a specified stack and priority.
;
;	Usage:		AllocateThreadLong label, stacksegval, priority

AllocateThreadLong MACRO lab, stkseg, prio
	push	ax
	push	cx
	push	dx
	push	es
	mov	bx, prio		; (BX) = thread priority.
	mov	ax, stkseg
	mov	es, ax			; (ES) = stack segment.
	lea	ax, lab                 ; (AX) = FWA, CS-relative execution stream.
	mov	cx, cs			; (CX:AX) = FWA, execution stream.
	mov	dl, SYS_ALLOCATE_THREAD_LONG ; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
        pop     es
	pop	dx
	pop	cx
	pop	ax
	ENDM

;***	AllocateTimer - Allocate a Timer Object.
;
;	This macro is used to allocate a timer object and initialize
;	its context and expiration routine parameters.
;
;	Usage:		AllocateTimer timer, context, expiration_rtn

AllocateTimer MACRO tmr, ctx, exprtn
	push	ax
	push	bx
	push	cx
	push	dx
	mov	ax, ctx                 ; (AX) = timer routine context.
	mov	bx, cs			; (BX) = seg FWA, expiration rtn.
	mov	cx, exprtn		; (CX) = ofs FWA, expiration rtn.
	mov	dl, SYS_ALLOCATE_TIMER	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	cx
	pop	bx
	mov	tmr, ax                 ; store handle to timer object.
	pop	ax
	ENDM

;***	DeallocateTimer - Free a Timer Object.
;
;	This macro is used to deallocate a timer object and return it
;	to the system.
;
;	Usage:		DeallocateTimer timer

DeallocateTimer MACRO tmr
	push	ax
	push	dx
	mov	ax, tmr                 ; (AX) = handle to timer object.
	mov	dl, SYS_DEALLOCATE_TIMER; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	StartTimer - Start a Timer Object.
;
;	This macro is used to start a timer object and specify the
;	number of milliseconds before the expiration routine should
;	be executed.
;
;	Usage:		StartTimer timer, deltatime

StartTimer MACRO tmr, delta
	push	ax
	push	cx
	push	dx
	mov	ax, tmr                 ; (AX) = handle to timer object.
	mov	cx, delta		; (CX) = ms until timer shall expire.
	mov	dl, SYS_START_TIMER	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	cx
	pop	ax
	ENDM

;***	StopTimer - Stop a Timer Object.
;
;	This macro is used to stop a timer object.
;
;	Usage:		StopTimer timer

StopTimer MACRO tmr
	push	ax
	push	dx
	mov	ax, tmr                 ; (AX) = handle to timer object.
	mov	dl, SYS_STOP_TIMER	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax
	ENDM

;***	BREAKPOINT - Break Into Debugger.
;
;	This macro breaks into the debugger by issuing an INT 3 instruction.
;	If DEBUG=1, then this code gets compiled.  If it is 0, then it doesn't.

BREAKPOINT MACRO
	int	3
	ENDM

;***	DPRINTF - Display Arguments With Formatting.
;
;	This is exactly the same as the KPRINTF macro.

DPRINTF MACRO	str, args
	DBGSYS	<str>,<args>
	ENDM

;***	KPRINTF - Display Arguments With Formatting.
;
;	This is just like DPRINTF (for debugging) except that this macro
;	never gets turned off by turning off the DEBUG code.  This macro
;	is therefore used for permanent messages, such as the signon
;	banner, and catastrophic error messages.

KPRINTF MACRO	str, args
	DBGSYS	<str>,<args>
	ENDM

;***	DBGSYS - Internal Display Macro.
;
;	This macro is a worker macro that calls the kernel's display
;	processor.  See KPRINTF.ASM for a description of how it works.

DBGSYS	MACRO	str, args
	LOCAL	addr, bytes
DBGMSG	SEGMENT
addr	db	'&str', 0
DBGMSG	ENDS
bytes	=	0
	IRP	OPERAND, <args>
	push	OPERAND
bytes	=	bytes + 2
	ENDM	; (IRP)

	IF	bytes
	push	bp		; save caller's BP.
	mov	bp, sp		; install stack frame.
	add	bp, bytes	; (BP) = FWA, formatting string address.
	ENDIF	; (BYTES nonzero)

	int	DBGINT		; call the system print formatter.

;	Store the ofs FWA of the formatting string directly following the
;	INT instruction.  That way, the ISR can easily find the address
;	and skip over it when it returns.  This confuses the UNASSEMBLE
;	debugger a bit, so watch it.

	dw	OFFSET DGROUP:addr

	IF	bytes
	pop	bp		; restore caller's BP.
	add	sp, (bytes)	; dump all arguments.
	ENDIF	; (BYTES nonzero)
	ENDM

;***	DISPLAYSTR - display message without any formatted parameters.
;
;	Quick form of DPRINTF, the DISPLAY macro prints out a simple
;	ASCIIZ string and follows it with a CR/LF pair.  The work is
;	actually done by DisplayFar (in SYSINIT.ASM), which contains
;	an inline DPRINTF macro.  Naturally, DISPLAYs are not assembled
;	when the DEBUG symbol is not set to 1 (see DEFINES.INC).

DISPLAYSTR MACRO   str
	DISPLAY_INTERNAL <str>
	ENDM

DISPLAY_INTERNAL MACRO str
	LOCAL	addr
DBGMSG	SEGMENT
addr	db	str
	db	0
DBGMSG	ENDS

	call	DisplayFar

;	We store the offset address of the string to print in a word
;	directly following the call instruction, so that the DisplayFar
;	routine can easily find it.  Then, before returning, DisplayFar
;	will advance the return address by two and skip over the word.

	dw	offset DGROUP:addr	; stored right in-line.
	ENDM

;***	USEDOSDATA - Get DOSDATA in DS/ES with ASSUME.
;

USEDOSDATA MACRO reg
	IF	CGROUP_MODULE
	IFIDNI	<reg>,<ds>
	Pcall	UseDosDataDS
	ELSE
	Pcall	UseDosDataES
	ENDIF
	ELSE
	push	dx
	IFIDNI	<reg>,<ds>
	mov	dl, SYS_USEDOSDATA_DS
	ELSE
	mov	dl, SYS_USEDOSDATA_ES
	ENDIF
	int	SYSINT
	pop	dx
	ENDIF
	ASSUME	reg:DOSDATA
	ENDM

;***	USEPSP - Get Current PSP in DS/ES with ASSUME.
;

USEPSP MACRO reg
	IF	CGROUP_MODULE
	IFIDNI	<reg>,<ds>
	Pcall	UsePSPDS
	ELSE
	Pcall	UsePSPES
	ENDIF
	ELSE
	push	dx
	IFIDNI	<reg>,<ds>
	mov	dl, SYS_USEPSP_DS
	ELSE
	mov	dl, SYS_USEPSP_ES
	ENDIF
	int	SYSINT
	pop	dx
	ENDIF
	ASSUME	reg:PSP
	ENDM

;***	USEDGROUP - Get DGROUP into DS/ES with ASSUME.
;

USEDGROUP MACRO reg
	IF	CGROUP_MODULE
	IFIDNI	<reg>,<ds>
	Pcall	UseDgroupDS
	ELSE
	Pcall	UseDgroupES
	ENDIF
	ELSE
	push	ax
	mov	ax, DGROUP
	mov	reg, ax
	pop	ax
	ENDIF
	ASSUME	reg:DGROUP
	ENDM

;***	USENONE - Make Segment Register Unavailable.
;

USENONE MACRO reg
	ASSUME	reg:NOTHING
	ENDM

;***	DBGSTR	- Define addressable debugging string.
;
;	This macro is used to generate tables of WORD pointers that point
;	to strings elsewhere in DGROUP (actually, in DBGMSG).

DBGSTR	MACRO	str
	LOCAL	addr
DBGMSG	SEGMENT
addr	db	'&str'
	db	0
DBGMSG	ENDS
	dw	OFFSET DGROUP:addr
	ENDM

;***	BUGBUG	- Produce assembly error if SHOWBUGBUGS = 1.
;
;	This macro is used for internal documentation in the code so that
;	when SHOWBUGBUGS is set to a non-zero value, then when a module is
;	compiled, all of the unfinished code will be flagged with assembly
;	errors.  This makes sure we have all outstanding issues resolved
;	before shipping a release.

BUGBUG	MACRO	str
	IF	SHOWBUGBUGS
	IF1
	%out	%str
	ENDIF
	ENDIF
	ENDM

;***	PUSHALL - Save All API Registers on Stack.
;

PUSHALL MACRO
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	push	es
	ENDM

;***	POPALL - Restore All API Registers from Stack.
;

POPALL	MACRO
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	ENDM

;***	PUSHREG - Save Registers From Mask.
;
;	This macro is called to save a selected set of registers as indicated
;	by a register mask.  The registers are always saved in a certain order
;	that is exactly the reverse of how POPREG restores them.  Hopefully
;	this will save us some code space even though it should not be used
;	in the super-hot paths.

PUSHREG MACRO	reglist
	LOCAL	regmask
regmask =	0000h		; all bits off, meaning don't save anything.
	IRP	OPERAND, <reglist>
	IFIDNI	<OPERAND>,<AX>
regmask =	(regmask OR REG_AX)
	ENDIF
	IFIDNI	<OPERAND>,<BX>
regmask =	(regmask OR REG_BX)
	ENDIF
	IFIDNI	<OPERAND>,<CX>
regmask =	(regmask OR REG_CX)
	ENDIF
	IFIDNI	<OPERAND>,<DX>
regmask =	(regmask OR REG_DX)
	ENDIF
	IFIDNI	<OPERAND>,<SI>
regmask =	(regmask OR REG_SI)
	ENDIF
	IFIDNI	<OPERAND>,<DI>
regmask =	(regmask OR REG_DI)
	ENDIF
	IFIDNI	<OPERAND>,<DS>
regmask =	(regmask OR REG_DS)
	ENDIF
	IFIDNI	<OPERAND>,<ES>
regmask =	(regmask OR REG_ES)
	ENDIF
	IFIDNI	<OPERAND>,<BP>
regmask =	(regmask OR REG_BP)
	ENDIF
	ENDM	; (IRP)

;	Now generate the call to the system routine to save the registers.
;	The routine is responsible for skipping over the two-byte mask that
;	follows the call.

	call	PushRegistersByMaskFar
	dw	regmask         ; the mask falls right after the instruction.
	ENDM

;***	POPREG - Restore Registers From Mask.
;
;	This macro is called to restore a selected set of registers as indicated
;	by a register mask.  The registers are always restored in a certain order
;	that is exactly the reverse of how PUSHREG restores them.  Hopefully
;	this will save us some code space even though it should not be used
;	in the super-hot paths.

POPREG	MACRO	reglist
	LOCAL	regmask
regmask =	0000h		; all bits off, meaning don't restore anything.
	IRP	OPERAND, <reglist>
	IFIDNI	<OPERAND>,<AX>
regmask =	(regmask OR REG_AX)
	ENDIF
	IFIDNI	<OPERAND>,<BX>
regmask =	(regmask OR REG_BX)
	ENDIF
	IFIDNI	<OPERAND>,<CX>
regmask =	(regmask OR REG_CX)
	ENDIF
	IFIDNI	<OPERAND>,<DX>
regmask =	(regmask OR REG_DX)
	ENDIF
	IFIDNI	<OPERAND>,<SI>
regmask =	(regmask OR REG_SI)
	ENDIF
	IFIDNI	<OPERAND>,<DI>
regmask =	(regmask OR REG_DI)
	ENDIF
	IFIDNI	<OPERAND>,<DS>
regmask =	(regmask OR REG_DS)
	ENDIF
	IFIDNI	<OPERAND>,<ES>
regmask =	(regmask OR REG_ES)
	ENDIF
	IFIDNI	<OPERAND>,<BP>
regmask =	(regmask OR REG_BP)
	ENDIF
	ENDM	; (IRP)

;	Now generate the call to the system routine to restore the registers.
;	The routine is responsible for skipping over the two-byte mask that
;	follows the call.

	call	PopRegistersByMaskFar
	dw	regmask         ; the mask falls right after the instruction.
	ENDM

;***	ASSERT - Verify Correct Structure Type.
;
;	This macro is called to verify that a register points to a structure
;	of the correct type, to aid in debugging.  It calls the AssertXxx
;	routines in ERROR.ASM to do the work out-of-line, for space.  The
;	AssertXxx routines pop a word off the stack FOR YOU (pascal calling
;	conventions) so that you don't have to step over the inevitable
;	"ADD SP, 2" instruction that would simply clutter up the code.

ASSERT	MACRO	objtype, reg

	IFIDNI	<objtype>, <NFO>
	push	reg
	Pcall	AssertNfo
	ENDIF

	IFIDNI	<objtype>, <NCB>
	push	reg
	Pcall	AssertNcb
	ENDIF

	IFIDNI	<objtype>, <TPD>
	push	reg
	Pcall	AssertTpd
	ENDIF

	IFIDNI	<objtype>, <LFO>
	push	reg
	Pcall	AssertLfo
	ENDIF

	IFIDNI	<objtype>, <PCB>
	push	reg
	Pcall	AssertPcb
	ENDIF

	IFIDNI	<objtype>, <STACK>
	Pcall	AssertStack
	ENDIF

	IFIDNI	<objtype>, <DOSDATA>
	push	reg
	Pcall	AssertDosData
	ENDIF

	ENDM

