//***	MESSAGE.H -- Embedded DOS Messaging API Definitions for C Language Programs.
//
//1.	Functional Description.
//	This include file contains prototypes for the Embedded DOS MESSAGE API.
//
//2.	Modification History.
//	S. E. Jones	92/07/29.	Original for #1.099.
//	S. E. Jones	92/09/07.	#1.100, fixed API.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1992-1995 General Software, Inc.

#ifndef _MESSAGE_API
#define _MESSAGE_API

//
// This module depends on KTYPES.
//

#include "..\inc\ktypes.h"		// conditionally includes types.

//
// The following flags may be passed on SendMsg & ReceiveMsg requests.
// The WAIT option causes the operation to block until the send or receive
// is complete.  The BUFFER option is only valid on SendMsg, and causes
// the message system to automatically copy the sender's data
//

#define MSG_FLAGS_WAIT		0x0001	// block until operation complete.
#define MSG_FLAGS_BUFFER	0x0002	// user buffer is buffered by system.
#define MSG_FLAGS_USEREVENT	0x0004	// set user event when operation complete.

extern STATUS ExCreateMsgPort (PUCHAR AsciizName, PHANDLE Handle);

extern STATUS ExOpenMsgPort (PUCHAR AsciizName, PHANDLE Handle);

extern STATUS ExCloseMsgPort (HANDLE Handle);

extern STATUS ExSendMsg (
    HANDLE Handle,
    PUCHAR ReqBuf,
    USHORT ReqBufLen,
    USHORT Flags,
    HANDLE Event
    );

extern STATUS ExReceiveMsg (
    HANDLE Handle,
    PUCHAR Buffer,
    USHORT BufLen,
    USHORT *BytesTransferred,
    USHORT Flags,
    HANDLE Event
    );

#endif // not defined, _MESSAGE_API
