;** $Header:   K:/mvi1794/software/dos6xl/pvcs/dos6xl/inc/OEM.INv   1.14   Apr 11 2000 16:11:00   jcrittenden  $
;
;===================================================================
;***	OEM.INC -- Embedded DOS Adaptation Manifest Constants.
;
;1.	Functional Description.
;	This include file contains OEM-tunable parameters for Adaptations
;	of the Embedded DOS operating system.  There are more options listed
;	in this file than in your Adaptation Guide.  Please examine them
;	carefully and make sure that you have addressed every adaptation
;	issue in this file, or you may achieve unexpected results.
;
;2.	Modification History.
;	S. E. Jones	91/05/20.	Directory Reorganization.
;	S. E. Jones	91/06/06.	#1.084: Fixed BlockThread bug.
;	S. E. Jones	91/06/30.	#1.085: added sharing loaded option.
;	S. E. Jones	91/06/30.	#1.086: new version for FAT/disk bugfixes.
;	S. E. Jones	91/06/30.	#1.086: also BIOS 16h, 10h indivisibility.
;	S. E. Jones	91/07/11.	#1.086: conditionalized CATCH_IRQ7.
;	S. E. Jones	91/07/16.	#1.087: build to fix FORMAT,CHKDSK,SYS.
;	S. E. Jones	91/07/19.	#1.087: changed boot stack size.
;	S. E. Jones	91/07/19.	#1.087: added MS-Windows broadcast support.
;	S. E. Jones	91/07/25.	#1.087: added unarchitected OEM kernel functions.
;	S. E. Jones	91/07/26.	#1.087: added disk driver options.
;	S. E. Jones	91/07/27.	#1.087: completed COM debugger support.
;	S. E. Jones	91/07/27.	#1.087: added configurable timer timebase.
;	S. E. Jones	91/07/28.	#1.088: fixed console I/O & ^C checking.
;	S. E. Jones	91/08/05.	#1.089: minor bug fixes in FORMAT, CHKDSK.
;	S. E. Jones	91/08/09.	#1.090: critical error handling fixed.
;	S. E. Jones	91/08/09.	#1.090: moved disk retry count here.
;	S. E. Jones	91/08/09.	#1.090: moved disk params here.
;	S. E. Jones	91/09/08.	#1.091: turned off INT 21 debug trapping.
;	S. E. Jones	91/09/09.	#1.092: bug fixes for customer software.
;	S. E. Jones	91/11/19.	#1.094: allocated threads from pool.
;	S. E. Jones	91/11/21.	#1.094: nonstandard timebases.
;	S. E. Jones	91/12/05.	#1.094: added NMI handler option.
;	S. E. Jones	91/12/28.	#1.094: added Computer Dynamics ROM/RAM drives.
;	S. E. Jones	91/12/30.	#1.094: added conditional FCB code option.
;	S. E. Jones	92/01/04.	#1.095: added prioritize thread function.
;	S. E. Jones	92/01/26.	#1.096: sizzled allocpool kernel function.
;	S. E. Jones	92/04/23.	#1.097: sizzled sector run allocation.
;	S. E. Jones	92/04/23.	#1.097: corrected DOSTIMESTAMP function.
;	S. E. Jones	92/05/28.	#1.098: added ROM/RAM FSD.
;	S. E. Jones	92/07/13.	#1.099: fixed psp_loadsize problem.
;	S. E. Jones	92/10/21.	#1.100: fixed nonstandard timebase constants.
;	S. E. Jones	93/03/22.	#1.101: switched to 2K stack size from 1K.
;	S. E. Jones	93/03/24.	#1.101: added protocol manager option.
;	S. E. Jones	93/03/26.	#1.102: configurable pool, discontiguous arena.
;	S. E. Jones	93/05/22.	#1.103: added run-time kernel integrity checks.
;	S. E. Jones	93/05/23.	#1.104: optimized f/s, fixed file truncation.
;	S. E. Jones	93/06/09.	#1.105: abstracted BIOS ints, added freq div.
;	S. E. Jones	93/06/29.	#1.106: removed event logs.
;	S. E. Jones	93/09/26.	#2.000: new release level.
;	S. E. Jones	93/10/18.	#2.000: golden build.
;	S. E. Jones	93/12/08.	#2.001: fixed StartTimer/delta=0.
;	S. E. Jones	94/01/28.	#2.003, fixed processor detection for V53.
;	S. E. Jones	94/04/18.	#2.1.006, fixed volume label bug.
;	C. S. Rhodes	94/10/19.	#2.1.008, fixed config line parsing.
;	C. S. Rhodes	94/10/24.	#2.1.009, fixed CTRL-Z handling in CpmStringInput.
;	C. S. Rhodes	94/11/11.	#2.2, fixed floppy probs in dsk dev.
;	S. E. Jones	94/12/22.	#2.2, fixed disk drvr/utils for M-Systems.
;	S. E. Jones	95/01/06.	#2.2, fixed run sched. appendage rtn.
;	C. S. Rhodes	95/01/30.	#2.2, fixed FAT Rename file.
;	C. S. Rhodes	95/02/06.	#2.2, moved debugger to device driver.
;	S. E. Jones	95/02/04.	#2.2.11, added Win INT 2fh calls.
;	S. E. Jones	95/02/14.	#2.2.18, added CTL+ALT+DEL preprocessing.
;	C. S. Rhodes	95/02/22.	#2.2.20, changed verifying of hard drives.
;	C. S. Rhodes	95/02/28.	#2.2.21, fixed CreateTempFile, increased cache.
;	S. E. Jones	95/03/19.	#6-XL v23, golden build for release.
;	S. E. Jones	95/03/24.	#6-XL v24, fixed LABEL.
;	S. E. Jones	95/03/29.	#6-XL v25, fixed COMMAND.COM/DISKCOMP.
;	S. E. Jones	95/04/19.	#6-XL v26, removed PRINTF in DOSFCB.ASM.
;	S. E. Jones	95/05/03.	#6-XL v28, upcase CONFIG.SYS bytes.
;	S. E. Jones	95/06/27.	#6-XL v31, don't copy FCBs in PSP if ffffh.
;	S. E. Jones	95/07/09.	#6-XL v32, fixed INT 25h, 26h.
;	S. E. Jones	95/07/12.	#6-XL v33, save regs in IoCallDriver.
;	S. E. Jones	95/07/28.	#6-XL v34, master PSP's parent is self.
;	S. E. Jones	95/08/02.	#6-XL v35, fix DosCreate for dirs.
;	S. E. Jones	95/08/14.	#6-XL v36, fixed disk full msg in COMMAND.COM.
;	S. E. Jones	95/09/08.	#6-XL v38, added disable sched/default dbg options.
;	S. E. Jones	95/11/10.	#6-XL v40, added TFFS flush in FatWrite.
;	S. E. Jones	95/12/07.	#6-XL v41, flush after extendfile for TFFS.
;	S. E. Jones	96/01/02.	#6-XL v42, more flushes for TFFS.
;	S. E. Jones	96/01/26.	#6-XL v44, TFFS nesting level support.
;	S. E. Jones	96/02/29.	#6-XL v45, release.
;	S. E. Jones	96/04/09.	#6-XL v46, added quota override.
;	S. E. Jones	96/05/03.	#6-XL v47, added support for Syquest's >128KB FATs.
;	S. E. Jones	96/05/06.	#6-XL v48, fixed INT 21h fn 4300h.
;	S. E. Jones	96/06/17.	#6-XL v49, reworked FastCopy routine.
;	S. E. Jones	96/08/24.	#6-XL v50, finished 32-bit copy.
;	S. E. Jones	97/04/07.	#6-XL v51, misc internal builds.
;	S. E. Jones	97/04/07.	#6-XL v52, TFFS TS/ETS field in DSKDEV2.
;	S. E. Jones	97/05/14.	#6-XL v53, DosCreate[dir] close PSP handle.
;
;3.	NOTICE: Copyright (C) 1990-1997 General Software, Inc.

;	The following build options may be changed by the OEM to configure
;	the operating system.  Set an option equal to 1 to enable it, or
;	equal to 0 to disable it.

OPTION_RUN_COMMAND_SHELL=	1	; 1 to run COMMAND.COM, 0 for InitOem.
OPTION_PRINT_SPOOLER	=	0	; 1 to build spooler, 0 to skip it.
OPTION_CONFIG_SYS	=	1	; 1 to parse CONFIG.SYS, 0 to not.
OPTION_US_GOVERNMENT	=	0	; 1 if you're selling to the US Government.
OPTION_REPORT_SHARE_LOADED =	1	; 1 if int 2fh reports SHARE.EXE loaded.
OPTION_SUPPORT_WIN3	=	0	; 1 if Win 3.x runs, else 0 to save codespace.
OPTION_HARD_DISK_PARTITIONS =	1	; 1 to support hard disk partitions.
OPTION_READ_DRIVE_PARAMS=	1	; 1 if BIOS supports INT 13h, func 08h.
OPTION_DISK_IOCTLS	=	1	; 1 to support generic disk IOCTLs.
OPTION_NONFAT_FILESYS	=	0	; 1 to support additional non-FAT file systems.
OPTION_PROTECT_MODE	=	0	; FUTURE USE BY GENERAL; DO NOT DEFINE.
OPTION_NONSTANDARD_TIMEBASE =	1	; 1 to change timebase in SYSINIT.ASM.
OPTION_ROMRAM_DRIVE	=	0	; 1 to support addn'l ROM/RAM drives.
OPTION_SUPPORT_FCBS	=	1	; 1 to support FCBs, 0 to ignore them.
OPTION_INCLUDE_RAM_FILESYS =	0	; 1 to support RAM file system.
OPTION_RAM_FILESYS_IS_UNC =	0	; 1 if RAM files should have '\\' prefix.
OPTION_IDLE_CRASH	=	0	; 1 crash if IDLE thread starts running.
OPTION_SUPPORT_RTC	=	1	; 1 to enable real-time clock (CMOS).
OPTION_PRINT_MEMSIZE	=	1	; 1 displays "lowmem/himem=xxx/xxx".
OPTION_DISABLE_SERINIT	=	1	; 1 disables AUX driver initialization.
OPTION_SUPPORT_386	=	1	; 1 enables 32-bit context saves.
OPTION_SUPPORT_V53	=	0	; 1 enables V-series checking in GetProcessorType.
OPTION_SUPPORT_186	=	0	; 1 enables 186 checking in GetProcessorType.
OPTION_DEBUG_COM	=	0	; 1 to support COMx as debug terminal.
OPTION_DEMO_VERSION     =       0       ; 1 to print demo msg & timeout system.
OPTION_DEFAULT_DEBUGGER =	0	; 1 to occlude BIOS debugger entrypoints.
OPTION_DISABLE_SCHEDULER=	0	; 1 to disable INT 08h scheduler for testing.

DEMO_TIMEOUT_IN_MINUTES =	120	; # minutes until demo times-out.

;	The following options allow you to instruct the DOS to guard certain
;	BIOS calls with system calls to disable context switching.  Some BIOS
;	implementations have ISRs that do not save their registers; instead,
;	they indicate that an interrupt has occurred (such as a keystroke)
;	by simply modifying a register.  If a BIOS does this, then it may
;	change the contents of a register in a different thread context,
;	so that the polling loop would never see the change.  If you suspect
;	your target BIOS of using such a technique, then you should turn on
;	the appropriate options here.

OPTION_GUARD_VIDEO_BIOS =	0	; 1 if INT 10h is to be indivisible.
OPTION_GUARD_KEYBOARD_BIOS =	0	; 1 if INT 16h is to be indivisible.
OPTION_GUARD_DISK_BIOS	=	0	; 1 to enter crit section around INT 13h.
OPTION_GUARD_CTL_ALT_DEL =	0	; 1 to disable scheduler on CTL+ALT+DEL.

;	Some hardware generates spurious interrupts on INT 0fh (IRQ7).
;	If you encounter such a problem, then enable this option to cause
;	the DOS initialization routines to point the INT 0fh vector to
;	an IRET instruction, so that a wild interrupt does not occur.
;	Some embedded hardware actually uses INT 0fh in place of INT 09h
;	for the keyboard input ISR.  If you have such hardware, then you
;	must edit SYSINIT.ASM to point the 0fh vector at the INT9 handler.

OPTION_CATCH_IRQ7	=	0	; 1 if INT 0fh is pointed to IRET.

;	If selling to the U.S. Government, you must enable the
;	OPTION_US_GOVERNMENT switch, and you must also change the
;	following equate to contain your firm's name and address,
;	as required by the government publication, "Rights in Technical
;	Data and Computer Software."

GOVT_CONTRACTOR_NAME equ  'General Software, Inc., Box 2571, Redmond, WA 98073'

;	Hardware-specific interrupt vector assignments.

HARDWARE_TIMER_VECTOR	=	08h	; interrupt vector for hardware timer.
BIOS_VIDEO_SERVICE	=	10h	; video BIOS interrupt vector.
BIOS_KEYBOARD_SERVICE	=	16h	; keyboard BIOS interrupt vector.
BIOS_SERIAL_SERVICE	=	14h	; serial port BIOS interrupt vector.
BIOS_PRINTER_SERVICE	=	17h	; parallel port BIOS interrupt vector.
BIOS_MEMORY_SERVICE	=	12h	; memory BIOS interrupt vector.
BIOS_DISK_SERVICE	=	13h	; diskette & hard disk BIOS interrupt vector.
BIOS_TIME_SERVICE	=	1ah	; date/time BIOS interrupt vector.
BIOS_EQUIPMENT_SERVICE	=	11h	; equipment flags BIOS interrupt vector.
BIOS_VIRTUAL_SERVICE	=	15h	; ext. memory BIOS interrupt vector.
BIOS_KEYSCAN_SERVICE	=	15h	; keyboard mapper BIOS interrupt vector.

;	Default CONFIG.SYS parameters.

PARAM_FILES		=	20	; default number of files.
PARAM_FCBS		=	20	; default number of FCBs in system.
PARAM_BUFFERS		=	20	; default number of buffers (fake).
PARAM_COUNTRY_CODE	=	0	; selected country code (default).
PARAM_BREAK		=	1	; default break flag.
PARAM_VERIFY		=	1	; default verify flag (disabled cache).
PARAM_CACHESIZE         =	8	; default # of cache blocks.
PARAM_CACHEFLUSH	=	1000	; default # ms before dirty block gets flushed.
PARAM_CACHETTL		=	2000	; default # ms before block gets destroyed.

;	The following options must be configured if OPTION_ROMRAM_DRIVE is
;	set to 1.  If a Computer Dynamics STD Bus MEGA-MEMORY card is being
;	used as a ROM/RAM disk, then it needs a DEVICE=DRIVER.SYS CONFIG.SYS
;	statement when run under MS-DOS.  Embedded DOS does not have this
;	driver, but instead builds support for the extra drives DIRECTLY
;	in the disk driver.  If you set OPTION_ROMRAM_DRIVE to 1, then this
;	code will be enabled, and one or more additional ROM/RAM drives will
;	be assigned drive letters in the system, beginning with the BIOS drive
;	number FIRST_ROMRAM_DRIVE, up to drive number (FIRST_ROMRAM_DRIVE+
;	ADDITIONAL_ROMRAM_DRIVES).  If you enable ROM/RAM drives, YOU MUST
;	set ADDITIONAL_ROMRAM_DRIVES to a nonzero value.

FIRST_ROMRAM_DRIVE	=	64	; first BIOS drive number is 64.
ADDITIONAL_ROMRAM_DRIVES=	2	; support two drives starting there.

;	The following option is used by the disk driver to determine the
;	number of times to retry a disk BIOS operation before returning
;	a critical error to the caller.  ONLY THE DISK DRIVER uses this.

DISK_IO_RETRY_COUNT	=	2	; # times to retry I/O on worn media.

;	The following option is used by the disk driver ONLY IF YOU SET
;	OPTION_READ_DISK_PARAMS to 0.  In this event, you have told the
;	disk driver that the disk BIOS can't tell whether the form factor
;	of a drive is 3.5" or 5.25", so disks with a 0f9h media byte may
;	be either a 1.2Mb 5.25" floppy or a 720kb 3.5" floppy.	This means
;	you have to choose which one the disk driver will pick here.  You
;	must pick one of them if OPTION_READ_DISK_PARAMS is not 0.

DISK_F9_MEANS_12MB	=	0	; 1 if f9h means 5.25" 1.2Mb floppy.
DISK_F9_MEANS_720KB	=	1	; 1 if f9h means 3.5" 720kb floppy.

;	The following parameter is used as a nonstandard timebase latch
;	(input to the 8253 timer controller) on a standard PC.	This
;	number is used if OPTION_NONSTANDARD_TIMEBASE (defined above) is
;	set to 1.  The 8253 counts up to this value at a rate of 1.19318
;	million times per second (1193180 clocks/sec).	By specifying a
;	limit other than the default here, the controller can be made to
;	generate ISR08 interrupts faster.  This allows better software
;	timer resolution, and finer-grained multitasking, at the expense
;	of having more overhead per unit time in reschedulings.  The
;	example values below generates 11ms, 1ms, or 0.5ms ISR08 events
;	If you enable OPTION_NONSTANDARD_TIMEBASE, you must make changes
;	in ISR08 (in module SYSISR.ASM) to call the BIOS's INT 08 handler
;	more or less frequently, so that the disks spin-down and time-out
;	properly, and so that the system time is correctly maintained.
;   NOTE: Don't forget to change SYSTEM_TIME_BASE below.

TIMEBASE_500US		=	596	; 500us events.
TIMEBASE_1MS		=	1191	; 1ms events.
TIMEBASE_5MS		=	5956	; 5ms events.
TIMEBASE_11MS		=	13107	; 11ms events.
TIMEBASE_55MS		=	65535	; 55ms events (18.2 times/second).

NONSTANDARD_TIMEBASE	=	TIMEBASE_5MS

;	The following parameter is used to control how often threads get
;	rescheduled inside ISR08 (round-robin scheduling).  This is a bit
;	mask that is used to test the bottom few bits of the low 16-bits
;	of a timestamp maintained by the ISR08 code.  ISR08 will test the
;	timestamp for the bits being on, so the OEM should set the bottom
;	'n' bits to achieve divide by 2**n results.  Because timer ticks
;	occur about 18 times a second, it is costly to overall system
;	performance to reschedule threads on every timer tick.	We can
;	cut the overhead in half by calling every other time, and down to
;	25% by calling every fourth time.  Of course, time slices get
;	longer, with diminishing returns when we do this.

SCHEDULER_TIMER_MASK	=	0000000000000000b ; reschedule every tick

;	The following two parameters allow the OEM to configure the resolution
;	of the timer package without affecting any timer API calls from apps.
;	The TIMER_EXPIRATION_MASK parameter is used just like the parameter
;	above (SCHEDULER_TIMER_MASK) to control the duty cycle used to enter
;	the timer system in ISR08.  The SYSTEM_TIME_BASE parameter must be
;	set to the number of milliseconds between each invocation of the
;	timer expiration routine.  If you clear TIMER_EXPIRATION_MASK so that
;	the timer expiration routine fires every time, then you would set
;	SYSTEM_TIME_BASE to 55, because that is how many milliseconds are
;	between each clock tick.  If you set the bottom bit of the mask,
;	then SYSTEM_TIME_BASE should be set to 110.

TIMER_EXPIRATION_MASK	=	0000000000000000b ; expire timers every tick.
SYSTEM_TIME_BASE	=	5	; that's in ms of resolution.

;	System memory configuration.  This is the MINIMUM amount of memory
;	that will be allocated.  It is also the default.  You may wish to
;	change the amount here to a larger value if you don't want to change
;	it with the SYSTEMPOOL=nnnnn statement in CONFIG.SYS.  The upper limit
;	is approximately 60,000.

;MIN_POOL_SIZE	=	(20480)         ; this is 2*10K bytes.
MIN_POOL_SIZE	=	(40960)         ; this is 4*10K bytes.

;	Configuration file processing.

MAX_CONFIG_LINE_SIZE =	256		; max 256 bytes per line in CONFIG.SYS.

;	A few miscellaneous constants.	To reduce the size of the system,
;	we recommend reducing the number of threads and stacks at the same
;	rate, but NOT reducing the sizes of the stacks.  About 512 bytes
;	of the base of each INT21 stack are automatically used by the I/O
;	system for data, so the remaining 512 bytes are for the call stack.
;
;	You do need a few more INT21 stacks in this case, since it is possible
;	for the kernel to call itself through the INT 21h interface (the loader
;	does this, for example.)  The system stack size has to be less than
;	or equal to 512 bytes, and is only used during boot-up.  The stack
;	is located at the reserved low-memory area normally used as a scratch
;	buffer for the disk driver (0050h:0000h).

SYSTEM_STACK_SIZE =	512		; must be less than 512 (stack at 50:0).
MIN_THREAD_STACK_SIZE = 2048		; size of thread stack in BYTES.
INT21_STACK_SIZE  =	2048		; size of INT 21h stack.
MIN_INT21_STACKS  =	5		; number of INT 21h stacks.

;	The following equate MAY be changed by the OEM customer to reflect
;	the current build (minor version number) of the product, in a way
;	that does not interfere with the base release version numbers assigned
;	by General Software.  This string will be appended to the General
;	Software base version number (of the form 1.nnn), where "1" means
;	major release 1, and nnn is the software base number at GS.

;;OEM_ADAPTATION_BUILD	equ	' Evaluation Copy ' ; this is a STRING, not a VALUE.
OEM_ADAPTATION_BUILD	equ	' '  ; MVIMOD jmc 12/16/99 not using this anymore
OEM_BANNER  equ 'MVI DOS v1.08', 13, 10, 'Copyright (c) 1999-2000 Online Development, Inc.'

;	The following equate MUST be changed by any OEM customer that
;	is adapting OEM DOS (i.e., rebuilding it.)  You MUST substitute
;	your own account number (assigned by General Software) in this
;	equate so that your DOS release can be tracked and so that
;	applications can be made that can take advantage of your
;	adaptation.  If you do not know your OEM account number, call
;	General Software to obtain it.	It is critical that you do not
;	use any other number here.  Even if you relink the DOS, you
;	MUST change this number to your account number.

;;OEM_ACCOUNT_NUMBER	=	0		; 0 means General Software, Inc.
OEM_ACCOUNT_NUMBER	=	13797       ; 12/23/98 jmc  OLDI's account number

;	The following constants MUST NOT be changed by the OEM.  Instead,
;	they mark the build as released by General Software.  You may freely
;	change the way in which GS_DOSTYPE is included in the sign-on banner,
;	however, including removing its use in that context altogether.

GS_RELEASE_BUILD        equ     '6-XL [v54]'    ; release string for SYSINIT.ASM.
GS_DOSTYPE		equ	'Embedded DOS'	; name of DOS (OEM, Emb, Demo, etc.)

;	OEMs may define their own kernel extensions to the General Software
;	kernel API by using the unarchitected number space starting with
;	OEM_FUNCTION_BASE, and continuing up to the maximum available function
;	number, 255 (it must be expressable in 8 bits).  OEMs should add the
;	definitions for those function numbers here, and edit the file
;	SYSISR.ASM to include table entries for the newly-added functions.
;	The function bodies themselves should go in OEM.ASM or some other
;	OEM-defined module.

OEM_FUNCTION_BASE	=	128		; first OEM-assigned number.
OEM_SAMPLE		=	128		; first number, a sample one.
OEM_SET_EVENT_ISR       =       129             ; safe SetEvent for ISR
OEM_ALLOCATE_THREAD_LONGEX =    130             ; allocate thread with user stack
OEM_MAX_FUNCTION	=	131         	; first unsupported number.


;----------------------------------------------
;----------------------------------------------
; MVIMOD     MVI Definitions
;----------------------------------------------
;----------------------------------------------

MVIOPTION_USE_MVIBIOS         = 1            ; Use MVI BIOS for tick timer programming
MVIOPTION_32BIT_CONTEXT       = 1            ; Scheduler always saves/restores 32-bit context
MVIOPTION_STACK_DEBUG         = 0            ; Initialize thread stacks for debugging
MVIOPTION_PROGEXEC_DEBUG      = 0            ; Display program load info for debugging

;----------------------------------------------
; MVI BIOS Interrupt Vector and function codes
;----------------------------------------------
MVIBIOS_SERVICE_VECTOR  EQU     45h         ; Our custom interrupt
MVIBIOS_GETMSW          EQU     00h         ; Fetch the Crisp MSW
MVIBIOS_GETTAME         EQU     01h         ; Fetch the tame jumper state
MVIBIOS_READSERIALNO    EQU     02h         ; Read the 64-bit serial number
MVIBIOS_READNVCONFIG    EQU     03h         ; Read a byte from the NVCONFIG
MVIBIOS_WRITENVCONFIG   EQU     04h         ; Write a byte to the NVCONFIG
MVIBIOS_GETCONSOLE      EQU     05h         ; Get console state
MVIBIOS_SETTIMEBASE     EQU     06h         ; Setup 8254 timebase



