;***	THREAD.INC -- Embedded DOS Thread Object.
;
;1.	Functional Description.
;	The following structure defines a thread object.  This object is
;	manipulated by the routines in THREAD.ASM.  All thread objects are
;	allocated from system pool, so they are all addressable in DOSDATA.
;	The THREAD object is not visible to kernel components that use the
;	THREAD object, but it is included here for the debugger.
;
;	Operations on threads are:
;	    AllocateThread - create a new thread and begin executing it.
;	    DeallocateThread - terminate the current thread.
;	    AllocateProtThread - allocate a protect-mode thread.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/10/19.	#1.094, added PROTMODE bitflag.
;	S. E. Jones	91/11/19.	#1.094, added priority, fwdlink.
;	S. E. Jones	92/02/19.	#1.096, removed ACTIVE.
;	S. E. Jones	92/08/31.	#1.100, removed stackseg field.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

THREAD		struc
thread_fwdlink	dw	?		; ofs FWA, next thread object in database.
thread_flags	dw	?		; bitflags indicating thread's state.

;	The following two fields must occur in exactly this order, as
;	the values of SS:SP are loaded with one LSS SP, <xxx> instruction.

thread_sp	dw	?		; stack pointer register.
thread_ss	dw	?		; stack segment register.

;	Other thread information.

thread_blockid	dw	?		; FWA, event/mutex if blocked.
thread_priority dw	?		; priority (see below).
thread_name	dd	?		; 16:16 FWA, ASCIIZ name string.
thread_p1	dd	?		; user parameter #1.
thread_p2	dd	?		; user parameter #2.

;	User thread extension routines.  NULL pointers are NOT allowed;
;	instead, if the user passes a NULL pointer, we point to a do-nothing
;	routine.  This saves us from having to test for NULL on every thread
;	dispatch and rescheduling.

thread_run	dd	?		; user rtn called to load thread ctx.
thread_stop	dd	?		; user rtn called to save thread ctx.
thread_exit	dd	?		; user rtn called to terminate thread.
THREAD		ends

THREAD_FLAGS_CURRENT	=	0001h	; this is the current thread.
THREAD_FLAGS_BLOCKED	=	0002h	; this thread is blocked (mutex or event).
THREAD_FLAGS_386	=	0004h	; 80386/80486 state preserved.
THREAD_FLAGS_X87	=	0008h	; 80x87 state preserved.

;	Priorities for ThreadSetPriority API.

THREAD_PRIORITY_LOW	=	0	; lowest priority.
THREAD_PRIORITY_DEFAULT =	16384	; default priority.
THREAD_PRIORITY_HI	=	32767	; highest priority.
THREAD_PRIORITY_RESERVED=	32768	; reserved levels 32768-65535.

;	Information types for Set/Query Thread Information API.

THREAD_INFOTYPE_URUN	=	1
THREAD_INFOTYPE_USTOP	=	2
THREAD_INFOTYPE_UEXIT	=	3
THREAD_INFOTYPE_FLAGS	=	4	; current thread flags (386/x87).
THREAD_INFOTYPE_NAME	=	5	; thread's name.
THREAD_INFOTYPE_P1	=	6	; parameter #1 (for user program).
THREAD_INFOTYPE_P2	=	7	; parameter #2 (for user program).
