#************************************************************************
#
#   Title: Makefile for 1756-MVI CIP API Sample 
#
#   Abstract:
#       This file is used by the Microsoft NMake utility to build the
#       sample application.
#
#   Environment:
#               1756-MVI
#               MS-DOS
#               Microsoft C/C++ Compiler (16-bit)
#
#************************************************************************

#----------------------------------------------
# Note: The environment variables LIB and
# INCLUDE must be set to the path to the
# Microsoft C library and include files.
# For example:
#
#    set LIB=D:\MSVC15\LIB
#    set INCLUDE=D:\MSVC15\INCLUDE
# 
#----------------------------------------------
# Paths to Tools
# 
# Note: Modify the following paths to
# correspond to your environment.
#
#----------------------------------------------
CPATH   = D:\programs\MSVC15        # Location of Microsoft tools
CC      = $(CPATH)\bin\cl           # compiler
LINK    = $(CPATH)\bin\link         # linker
MAKE    = $(CPATH)\bin\nmake        # make utility


#----------------------------------------------
# Path to API Library and Include file
# 
# Note: Modify the following path to
# correspond to your environment.
#
#----------------------------------------------
BPAPILIB  = ..\api\cipapi.lib         # Path to Backplane API library
SPAPILIB  = ..\api\mvispapi.lib       # Path to Serialport API library
APIINC  = ..\api                      # Path to API include file

INCLUDES = samplem.mak $(APIINC)\cipapi.h $(APIINC)\mvispapi.h

#----------------------------------------------
# Options
#----------------------------------------------
CFLAGS  = /c /nologo /G3 /W3 /AL /Oi /Gx- /I $(APIINC)
LFLAGS  = /MAP:A /NOI /PACKC


sample.exe : sample.obj $(BPAPILIB) $(SPAPILIB) samplem.mak
    $(LINK) $(LFLAGS) sample.obj, $*.exe, $*.map, $(BPAPILIB) $(SPAPILIB), nul.def

clean:
    del *.exe
    del *.obj
    del *.map

rebuild:
    $(MAKE) -f samplem.mak clean
    $(MAKE) -f samplem.mak 

.c.obj:
    $(CC) $(CFLAGS) $*.c


sample.obj: sample.c $(INCLUDES)