;***	CTX.INC -- Embedded DOS Register Context As Saved By Debugger.
;
;1.	Functional Description.
;	The following structure defines the layout of the user's registers
;	in our debugger save area.  The 16-bit context is saved for 16-bit
;	threads only.  The 32-bit context is saved for threads with the
;	THREAD_FLAGS_386 bit set.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	93/11/05.	#2.001, added 32-bit context.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

CTX	struc
ctx_ss	dw	?
ctx_sp	dw	?
ctx_es	dw	?
ctx_ds	dw	?
ctx_bp	dw	?
ctx_di	dw	?
ctx_si	dw	?
ctx_dx	dw	?
ctx_cx	dw	?
ctx_bx	dw	?
ctx_ax	dw	?
ctx_ip	dw	?			; calling instruction pointer.
ctx_cs	dw	?			; calling code segment.
ctx_fl	dw	?			; calling flags.
CTX	ends

CTX32	 struc
ctx32_ss   dw	?
ctx32_sp   dw	?
ctx32_es   dw	?
ctx32_ds   dw	?
ctx32_gs   dw	?
ctx32_fs   dw	?
ctx32_ebp  dd	?
ctx32_edi  dd	?
ctx32_esi  dd	?
ctx32_edx  dd	?
ctx32_ecx  dd	?
ctx32_ebx  dd	?
ctx32_eax  dd	?
ctx32_ip   dw	?			; calling instruction pointer.
ctx32_cs   dw	?			; calling code segment.
ctx32_fl   dw	?			; calling flags.
CTX32	 ends
