#************************************************************************
#
#   Title: Borland C Makefile for 1756-MVI DH-485 API Sample Code
#
#   Environment:
#               1756-MVI
#               MS-DOS
#               Borland C/C++ Compiler (16-bit)
#
#               Copyright (c) 2000 Online Development, Inc.
#
#************************************************************************

# We need to know what version of BC++ compiler to use. : 3.X, 4.x, or 5.x
BCVER = 5

#----------------------------------------------
# Paths to Tools
#
# Note: Modify the following paths to
# correspond to your environment.
#
#----------------------------------------------
!if $(BCVER) > 3
CPATH   = d:\bc5           # Location of Borland tools
!else
CPATH   = D:\BC31          # Location of Borland tools
!endif
CC      = $(CPATH)\bin\Bcc          # compiler
LINK    = $(CPATH)\bin\TLink        # linker
MAKE    = $(CPATH)\bin\Make         # make utility


#----------------------------------------------
# Path to API Library and Include file
#
# Note: Modify the following path to
# correspond to your environment.
#
#----------------------------------------------
DOSLIB    = ..\api\kernel.lib       # path to DOS6XL library files
SPAPILIB  = ..\api\mvispapi.lib     # Path to Serialport API library
DHAPILIB  = ..\api\dh485api.lib     # Path to DH-485 API library
APIINC  = ..\api                    # Path to API include file


#----------------------------------------------
# Options
#----------------------------------------------
# Compile/link options to disable exception handling in
# BC++ compilers that don't support it generate errors.
# (e.g. BC 3.1).
!if $(BCVER) > 3
CFLAGS5 = -x
NOEHLIB = noehl.lib
!endif

CFLAGS  = -c -v- -w -ml -3 $(CFLAGS5) -I$(APIINC)
LFLAGS  = -v- -Tde -c -m

#----------------------------------------------
# Target Name
#----------------------------------------------
TARG    = sample

#----------------------------------------------
# Object files
#----------------------------------------------
OBJ     = $(TARG).obj

#----------------------------------------------
# Include files
#----------------------------------------------
INCLUDES = sampleb.mak $(APIINC)\mvispapi.h $(APIINC)\dh485api.h


$(TARG).exe : $(OBJ) $(SPAPILIB)
    $(LINK) @&&|
    $(LFLAGS) c0l $(OBJ), $*.exe, $*.map, $(NOEHLIB) cl $(DOSLIB) $(SPAPILIB) $(DHAPILIB)
|
    @echo SUCCESS!

clean:
    del *.exe
    del *.obj
    del *.map

rebuild:
    $(MAKE) -fsampleb.mak clean
    $(MAKE) -fsampleb.mak

.c.obj:
    $(CC) $(CFLAGS) $*.c


$(TARG).obj: $(TARG).c $(INCLUDES)
