/*****************************************************************************
*
*   Title:        DF1 Half Duplex Slave Definitions
*
*   Abstract:     This file contains definitions and declarations
*                 needed for developing applications which use the
*                 MVI API.
*
*
*   Environment:  MVI DF1 Half Duplex Slave Module
*                 Borland/Microsoft C/C++ Compiler
*                 General Software Embedded DOS 6-XL
*
*   Author:       BJS
*                 Copyright (c) 2000 Online Development, Inc.
*
*****************************************************************************/

#ifndef _MVIHDSAI_H
#define _MVIHDSAI_H

/*---------------------------------------------------------
**  The MVI serial port API must be included.
**-------------------------------------------------------*/
#ifndef _MVISPAPI_H
#include "mvispapi.h"
#endif  /* ifndef _MVISPAPI */

/***********************************
**  DEFINITIONS
************************************/
// DF1 port configuration definitions
#define 	DUP_PACKET_DIS		0x00	// Duplicate packet det disabled
#define 	DUP_PACKET_ENA		0x01	// Duplicate packet det enabled
#define		BCC_ERROR_CHK 		0x00	// Use BCC error checking									  
#define		CRC_ERROR_CHK 		0xFF	// Use CRC error checking
#define 	HSHAKE_CC			0x01	// Enable hardware handshake - continuous
										// carrier
#define		HSHAKE_NCC			0x02	// Enable hardware handshake - non-continuous
										// carrier
// MVI DF1 error codes
#define		MVI_ERR_NOSTAT		0x09	// Return error code which indicates
										// that there is no status data available
#define		MVI_ERR_NODATA		0X0A	// Return error code which indicates that
										// the function has no data to return
#define		MVI_ERR_OS			0X0B	// Return error code which indicates that
										// the OS was not able to initiate a thread,
										// event, or timer
#define 	MVIDF1_XMITTING		0X01	// Packet transmit error code that
										// indicates a packet is currently
										// queued and is attempting to be
										// transmitted.
#define		MVIDF1_SUCCESS		0X02	// Packet transmit error code that
										// indicates the packet has been
										// successfully xmitted
#define		MVIDF1_FAILED		0X03	// Packet transmit error code that
										// indicates xmission of the packet
										// failed

// Diagnostic counter access numbers
#define 	PACKETS_RCVD 		0x00	// Total packets received
#define		POLLS_RCVD 			0x01	// Total ENQs received
#define		NAKS_RCVD 			0x02	// Total NAKs received
#define		BAD_CRC_BCC 		0x03	// Total packets with bad error check values
#define		DUPS_RCVD 			0x04	// Total number of duplicate packets received
#define		PACKETS_XMITTED 	0x05	// Total number of packets transmitted
#define		SINK_FULL 			0x06 	// Total rejected packets for full sink buffer
#define		SOURCE_FULL 		0x07	// Total rejected packets for full source buffer
#define		MESSAGE_RETRIES 	0x08	// Total number of message retries


/************************************
**  STRUCTURES
*************************************/

// This is the port configuration data structure.  A
typedef struct tagHDSCFG
{
    BYTE Baud;                  		// Desired baud rate
	BYTE Parity;						// Desired parity
	BYTE Stop;							// Desired stop bits
    BYTE DupPacket;             		// Duplicate packet detection enable/disable
    BYTE ErrorDet;        				// CRC or BCC error checking selection
    BYTE Station;          				// Station address. Range: 0-254;255 = broadcast
    BYTE MsgRetries;           			// Number of times a single message will be
										// transmitted in response to a poll
    BYTE Handshake;           			// Hardware handshake control;
    									// 	HSHAKE_NONE =none 
										// 	HSHAKE_NCC =half-dup,w/o continuous carrier
										// 	HSHAKE_CC =half-dup,with continuous carrier
	WORD RTSSend;						// The RTS send delay in increments of 1 mS
	WORD RTSOff;						// The RTS off delay in	increments of 1 mS
    int  ComPort;               		// Set to COM1 or COM2 or COM3
}HDSCFG;
// This is the source-transmit-status data structure.  Data returned from the API call
// MVIdf1_HDSGetPktStat will follow this format.
typedef struct tagSRCXMT
{
	BYTE Src;							// Source address of application
										// layer packet
	BYTE Cmd;							// Command value of application
										// layer packet
	WORD TNS;							// TNS count for application layer
										// packet
	BYTE XmitStatus;					// Transmit status of the application
										// packet
}SRCXMT;
/************************************
**  VERSION INFORMATION STRUCT
*************************************/
typedef struct tagMVIHDSVERSIONINFO
{
    WORD    APISeries;
    WORD    APIRevision;
}MVIHDSVERSIONINFO;

/*************************************
**  API FUNCTION PROTOTYPES
*************************************/

MVIAPIENTRY MVIdf1_HDSPutPkt(BYTE,BYTE *,WORD *);
MVIAPIENTRY MVIdf1_HDSOpenPort(HDSCFG *);
MVIAPIENTRY MVIdf1_HDSGetPktStat(BYTE,SRCXMT *);
MVIAPIENTRY MVIdf1_HDSGetDiagnostics(BYTE,WORD *,BYTE,BYTE);
MVIAPIENTRY MVIdf1_HDSClosePort(BYTE);
MVIAPIENTRY MVIdf1_HDSGetPkt(BYTE,BYTE *,WORD *);
MVIAPIENTRY MVIdf1_HDSGetVersionInfo(MVIHDSVERSIONINFO *);
#endif
