;***	FCB.INC -- Embedded DOS File Control Block.
;
;1.	Functional Description.
;	This structure defines the layout of an FCB, which is used for the
;	DOS 1.0 compatibility file system calls.  This layout was derived
;	from the information in Ray Duncan's "Advanced MS-DOS" book, published
;	by Microsoft Press.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

FCB		struc
fcb_driveid	db	?
fcb_filename	db	8 dup (?)	; first component of filename.
fcb_extension	db	3 dup (?)	; second component (after the dot).
fcb_cbn         dw	?		; current block number.
fcb_rs		dw	?		; current record size.
fcb_filesize	dd	?		; file size.
fcb_date	dw	?		; date that file was created/updated.
fcb_time	dw	?		; time that file was created/updated.

;	The following fields are reserved by Embedded DOS.

fcb_sfd         dw	?		; FWA, SFD covering this FCB.
		db	06h dup (?)	; reserved fields.

;	Continuation of the public components of an FCB.

fcb_crn         db	?		; current record number (yes, a byte).
fcb_rrn         dd	?		; relative record number (yes, a dd).
FCB		ends

;***	EFCB - Extended File Control Block.
;
;	This structure defines the layout of an Extended FCB, which is
;	used for extended DOS 1.0 compatibility file system calls.  Basically,
;	if in using an FCB, the DOS finds that fcb_driveid is 0ffh, then
;	it knows that the address is really pointing to an EFCB instead,
;	which contains an FCB plus some preamble stuff.

EFCB		struc
efcb_sig	db	?		; always 0ffh.
		db	5 dup (?)	; reserved.
efcb_attribute	db	?		; attribute byte.
efcb_fcb	db	(SIZE FCB) dup (?) ; the actual FCB, above.
EFCB		ends
