;***	FFO.INC -- Embedded DOS FAT File Object.
;
;1.	Functional Description.
;	This structure maintains the state for an opened FAT file object
;	managed by the FAT FSD.  This state is completely internal to the
;	FAT FSD and is not visible to the rest of Embedded DOS.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/01/13.	Built sector run model at open time.
;	S. E. Jones	92/03/24.	#1.097, added FMT hotpath fields.
;	S. E. Jones	92/09/05.	#1.100, added second FAT bitflag.
;	S. E. Jones	93/09/26.	#2.000, added write tested flag.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	94/04/18.	#2.1, added flags2.
;	S. E. Jones	95/01/24.	#2.2, release.
;	S. E. Jones	98/02/24.	#6XL v56, added UPD_TIMESTAMP.
;
;3.	NOTICE: Copyright (C) 1990-1998 General Software, Inc.

FFO		struc
ffo_fwdlink	dw	?		; offset ptr, next ffo in chain.
ffo_flags	dw	?		; bitflags, defined below.
ffo_flags2	dw	?		; more bitflags, defined below.

;	Directory search state (also, we use ffo_currclust).

ffo_dircluster	dw	?		; starting cluster of containing dir.
ffo_secleft	dw	?		; sectors left/current cluster.
ffo_dirleft	dw	?		; entries left/current sector.

;	Information about the open file's directory entry.

ffo_dirofs	dw	?		; offset of dir entry within sector.
ffo_dirsec	dd	?		; dir entry sector number.
ffo_dirsize	dd	?		; file size as it appears in the directory.
ffo_date	dw	?		; file date stamp.
ffo_time	dw	?		; file time stamp.
ffo_start	dw	?		; starting cluster number (0=no chain yet).

;	Information about the current file pointer & extended file size.
;	The file pointer is a logical byte offset that is used to scan
;	through the sector run map (below) on reads, writes, and seeks.

ffo_size	dd	?		; actual file size in bytes.
ffo_fileptr	dd	?		; rel file pointer (0=beginning of file).

;	The file's allocation chain is translated from the FAT chain at
;	open time to a more efficient "sector run" array that is dynamically
;	growable.  Adjacent "clusters" are coalesed into single entries in
;	this table, making it possible to perform multi-cluster reads in
;	a single I/O operation.  This method allows us to beat Microsoft's
;	large I/O disk performance.  The cache in the file system allows
;	us to beat their small I/O performance.

ffo_fmt         dw	?		; ofs FWA, FMTE array.
ffo_fmtlimit	dw	?		; max number of entries/FMT.
ffo_fmtentries	dw	?		; actual # entries/FMT.
ffo_lastclust	dw	?		; hint for FMT allocation.
ffo_fileclusts	dw	?		; hint for FMT allocation.

;	BUGBUG:  The following two entries are going to be removed VERY SOON!!!

ffo_currclust	dw	?		; current cluster number (0=no chain yet).
ffo_currofs	dw	?		; abs file ptr offset within sector.

;	Information about the underlying file system geometry.

ffo_spc         dw	?		; sectors per cluster, this drive.
ffo_spf         dw	?		; sectors per FAT (used in chain allocation).
ffo_tc		dw	?		; total clusters (used in allocation).
ffo_mde         dw	?		; maximum directory entries/root dir.
ffo_da		dd	?		; 1st data sector # following root dir.
ffo_rootdir	dd	?		; starting sector number of root directory.
ffo_fat         dd	?		; starting sector # in FAT.

;	The following fields point to the Embedded DOS structures that define
;	the open handle for the I/O and the physical drive associated with
;	the open handle.  They are set by BuildFfo and remain for the life
;	of an FFO.  The offset values are relative to DOSDATA, which is a
;	valid assumption for the next few releases of Embedded DOS.

ffo_shte	dw	?		; FWA, SHTE for the system handle (DOSDATA).
ffo_sdte	dw	?		; FWA, SDTE for the underlying drive (DOSDATA).

;	The following fields are used as workspace inside the FAT File System
;	because there just aren't enough registers to keep all this handy.
;	They cannot be used across calls to the FSD.

ffo_workbuf	dw	?		; FWA, DOSDATA:ffowork buffer.
ffo_fsrp	dd	?		; FWA, FSRP for the current operation.

ffo_path	dd	?		; FWA, path being parsed.
ffo_sector	dd	?		; current sector.
ffo_count	dw	?		; bytes left to go.

;	The following fields are used by the cluster allocation routines.

ffo_nclust	dw	?		; countdown of clusters to go.

ffo_fnddirsec	dd	?		; dir entry sector number.
FFO		ends

FFO_FLAGS_OPEN		=	0001h	; entry represents an open file.
FFO_FLAGS_SEARCH	=	0002h	; entry represents an open search.
FFO_FLAGS_DIRUPD	=	0004h	; directory entry must be updated.
FFO_FLAGS_READONLY	=	0008h	; file is read-only.
FFO_FLAGS_16BITFAT	=	0010h	; FAT is 16-bit, not 12-bit.
FFO_FLAGS_BUFFER	=	0020h	; work buffer is attached to FFO.
FFO_FLAGS_LINKED	=	0040h	; FFO is in FileList.
FFO_FLAGS_SUBDIR	=	0080h	; search is on a subdirectory, not root.
FFO_FLAGS_READPERM	=	0100h	; reads permitted.
FFO_FLAGS_WRITEPERM	=	0200h	; writes permitted.
FFO_FLAGS_DENYREAD	=	0400h	; don't let others read.
FFO_FLAGS_DENYWRITE	=	0800h	; don't let others write.
FFO_FLAGS_FIXED         =	1000h	; fixed disk (data won't get stale).
FFO_FLAGS_2FATS         =	2000h	; if set, second FAT exists.
FFO_FLAGS_WRITE_TESTED	=	4000h	; if set, we've done a write check.
FFO_FLAGS_REBUILDFMT	=	8000h	; scratch bit for FATFMT routines.

FFO_FLAGS2_VOLUME_LABEL =	0001h	; FFO represents an open volume label.
FFO_FLAGS2_DIR_ENTRY	=	0002h	; empty directory entry valid.
FFO_FLAGS2_UPD_TIMESTAMP=	0004h	; reload FFO with DOS date/time stamp.

FFO_FMT_SIZE		=	50	; # elements in default FMT.

FFOWORK         struc
ffowork_name	db	11 dup (?)	; unpacked filename to scan for.
ffowork_name2	db	11 dup (?)	; second unpacked filename (rename).
ffowork_buffer	db	512 dup (?)	; sector buffer to read directory into.
ffowork_dde	db	(SIZE DDE) dup (?) ; found disk directory entry.
FFOWORK         ends
