//***	KTYPES.H -- Kernel Type Definitions for C Language Programs.
//
//1.	Functional Description.
//	This include file contains type definitions for General Software
//	operating system and application products.
//
//2.	Modification History.
//	S. E. Jones	91/10/12.	#1.093, Original.
//	S. E. Jones	92/01/12.	#1.095, slstatus->status.
//	S. E. Jones	93/09/08.	#1.106, added ifndef's.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1991-1995 General Software, Inc.

#ifndef _KTYPES
#define _KTYPES

#ifndef UCHAR
#define UCHAR unsigned char
#endif

#ifndef PUCHAR
#define PUCHAR unsigned char *
#endif

#ifndef USHORT
#define USHORT unsigned short
#endif

#ifndef PUSHORT
#define PUSHORT unsigned short *
#endif

#ifndef ULONG
#define ULONG unsigned long
#endif

#ifndef PULONG
#define PULONG unsigned long *
#endif

#ifndef CHAR
#define CHAR char
#endif

#ifndef PCHAR
#define PCHAR char *
#endif

#ifndef SHORT
#define SHORT short
#endif

#ifndef PSHORT
#define PSHORT short *
#endif

#ifndef LONG
#define LONG	long
#endif

#ifndef PLONG
#define PLONG long *
#endif

#ifndef BOOLEAN
#define BOOLEAN unsigned short
#endif

#ifndef PBOOLEAN
#define PBOOLEAN unsigned short *
#endif

#ifndef VOID
#define VOID void
#endif

#ifndef PVOID
#define PVOID void *
#endif

#ifndef NULL
#define NULL ((PVOID)(0L))
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif

//
// The Kernel API functions return a 16-bit STATUS value.  This value
// may be interpreted according to the codes defined in SYSTEM.H, with
// the DOSERR_ prefixes.
//

#ifndef STATUS
#define STATUS unsigned short		// return-code status type.
#endif

//
// General Kernel API syntax.
//

#ifndef IN
#define IN				// parameter is readable.
#endif

#ifndef OUT
#define OUT				// parameter is writable.
#endif

#ifndef OPTIONAL
#define OPTIONAL			// parameter is optional.
#endif

//
// Handles are just unsigned shorts.
//

#ifndef HANDLE
#define HANDLE unsigned short
#endif

#ifndef PHANDLE
#define PHANDLE unsigned short *
#endif

#endif // not defined, _KTYPES
