;***	LOG.INC -- Embedded DOS System Log Entry/Element.
;
;1.	Functional Description.
;	This structure defines the layout of an entry in the system's
;	event log.  This log is managed and displayed by the event
;	manager user mode program.  The log can be started and stopped
;	by sending system events to the logger.
;
;2.	Modification History.
;	S. E. Jones	92/12/18.	#1.101, original.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1992-1995 General Software, Inc.

LOG		struc
log_lowtime	dw	?		; low 16 bits of timestamp from 8253.
log_hightime	dd	?		; high 32 bits of timestamp (18hz units).
log_event	dw	?		; event code.
LOG		ends

;	User-defined event codes have the high bit set, as follows.

LOG_TYPE_USER		=	8000h	; types above this value are user types.

;	The following system-defined event codes control the event log system.

LOG_TYPE_DISABLE	=	0	; disable logging.
LOG_TYPE_ENABLE         =	1	; enable logging.
LOG_TYPE_RESET		=	2	; clear log (don't change enable/disable).

;	The following system-defined event codes are broadcast by the
;	Embedded DOS kernel to indicate internal events.

LOG_TYPE_IDLE_THREAD	=	3	; the idle thread is executing.
LOG_TYPE_SAVE_CONTEXT	=	4	; the current thread context is saved.
LOG_TYPE_RESTORE_CONTEXT=	5	; the current thread context is loaded.
LOG_TYPE_SYSTEM_TICK	=	6	; ISR08 entered.
LOG_TYPE_TIMER_EXEC	=	7	; user timer routine called.
LOG_TYPE_TIMER_DONE	=	8	; user timer routine returned.
LOG_TYPE_KERNEL_EXEC	=	9	; kernel function dispatched.
LOG_TYPE_KERNEL_DONE	=	10	; kernel function returned.
LOG_TYPE_FSHELP_EXEC	=	11	; FS helper function dispatched.
LOG_TYPE_FSHELP_DONE	=	12	; FS helper function returned.
LOG_TYPE_INT21_EXEC	=	13	; INT 21h function dispatched.
LOG_TYPE_INT21_DONE	=	14	; INT 21h function returned.
LOG_TYPE_INT13_EXEC	=	15	; INT 13h function dispatched.
LOG_TYPE_INT13_DONE	=	16	; INT 13h function returned.
